/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server;

import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.rest.server.CloudStoreRest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);

    public DefaultExceptionMapper(@Context CloudStoreRest cloudStoreRest) {
        logger.debug("<init>: Instance created. cloudStoreRest={}", (Object)cloudStoreRest);
        if (cloudStoreRest == null) {
            throw new IllegalArgumentException("cloudStoreRest == null");
        }
    }

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof DeferredCompletionException) {
            logger.debug(String.valueOf(throwable), throwable);
        } else {
            logger.error(String.valueOf(throwable), throwable);
        }
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        Error error = new Error(throwable);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/xml").entity((Object)error).build();
    }
}

