/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.auth;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.UUID;

public class TransientRepoPassword {
    private final UUID serverRepositoryId;
    private final UUID clientRepositoryId;
    private final AuthToken authToken;
    private final char[] password;

    protected TransientRepoPassword(UUID serverRepositoryId, UUID clientRepositoryId, AuthToken authToken) {
        this.serverRepositoryId = (UUID)AssertUtil.assertNotNull((Object)serverRepositoryId, (String)"serverRepositoryId");
        this.clientRepositoryId = (UUID)AssertUtil.assertNotNull((Object)clientRepositoryId, (String)"clientRepositoryId");
        this.authToken = (AuthToken)AssertUtil.assertNotNull((Object)authToken, (String)"authToken");
        authToken.makeUnmodifiable();
        AssertUtil.assertNotNull((Object)authToken.getExpiryDateTime(), (String)"authToken.expiryDateTime");
        AssertUtil.assertNotNull((Object)authToken.getPassword(), (String)"authToken.password");
        this.password = authToken.getPassword().toCharArray();
    }

    public UUID getServerRepositoryId() {
        return this.serverRepositoryId;
    }

    public UUID getClientRepositoryId() {
        return this.clientRepositoryId;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public char[] getPassword() {
        return this.password;
    }
}

