/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CollisionPrivate;
import org.subshare.local.persistence.CollisionPrivateDao;

public class CollisionPrivateDtoConverter {
    private final LocalRepoTransaction transaction;

    public static CollisionPrivateDtoConverter create(LocalRepoTransaction transaction) {
        return (CollisionPrivateDtoConverter)ObjectFactoryUtil.createObject(CollisionPrivateDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected CollisionPrivateDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
    }

    public CollisionPrivateDto toCollisionPrivateDto(CollisionPrivate collisionPrivate) {
        AssertUtil.assertNotNull((Object)((Object)collisionPrivate), (String)"collisionPrivate");
        CollisionPrivateDto result = new CollisionPrivateDto();
        result.setCollisionId(collisionPrivate.getCollision().getCollisionId());
        result.setComment(collisionPrivate.getComment());
        result.setResolved(collisionPrivate.getResolved());
        return result;
    }

    public CollisionPrivate putCollisionPrivateDto(CollisionPrivateDto collisionPrivateDto) {
        AssertUtil.assertNotNull((Object)collisionPrivateDto, (String)"collisionPrivateDto");
        CollisionDao cDao = (CollisionDao)((Object)this.transaction.getDao(CollisionDao.class));
        Collision collision = cDao.getCollisionOrFail(collisionPrivateDto.getCollisionId());
        return this.putCollisionPrivateDto(collision, collisionPrivateDto);
    }

    public CollisionPrivate putCollisionPrivateDto(Collision collision, CollisionPrivateDto collisionPrivateDto) {
        AssertUtil.assertNotNull((Object)((Object)collision), (String)"collision");
        AssertUtil.assertNotNull((Object)collisionPrivateDto, (String)"collisionPrivateDto");
        CollisionPrivateDao cpDao = (CollisionPrivateDao)((Object)this.transaction.getDao(CollisionPrivateDao.class));
        CollisionPrivate result = cpDao.getCollisionPrivate(collision);
        if (result == null) {
            result = new CollisionPrivate();
            result.setCollision(collision);
        }
        result.setComment(collisionPrivateDto.getComment());
        result.setResolved(collisionPrivateDto.getResolved());
        result = (CollisionPrivate)cpDao.makePersistent(result);
        return result;
    }
}

