/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.provider;

import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.ForceNonTransientContainer;
import co.codewizards.cloudstore.ls.core.invoke.ObjectGraphContainer;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverter;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverterFactory;
import co.codewizards.cloudstore.ls.core.provider.ExtObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/java-native+oref"})
public class JavaNativeWithObjectRefMessageBodyReader
implements MessageBodyReader<Object> {
    private final ObjectRefConverterFactory objectRefConverterFactory;
    @Context
    private SecurityContext securityContext;

    public JavaNativeWithObjectRefMessageBodyReader(ObjectRefConverterFactory objectRefConverterFactory) {
        this.objectRefConverterFactory = (ObjectRefConverterFactory)AssertUtil.assertNotNull((Object)objectRefConverterFactory, (String)"objectRefConverterFactory");
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectRefConverter objectRefConverter = this.objectRefConverterFactory.createObjectRefConverter(this.securityContext);
        try (ResolvingObjectInputStream oin = new ResolvingObjectInputStream((InputStream)new NoCloseInputStream(entityStream), objectRefConverter);){
            Object o = oin.readObject();
            ObjectGraphContainer objectGraphContainer = (ObjectGraphContainer)o;
            for (ForceNonTransientContainer forceNonTransientContainer : objectGraphContainer.getTransientFieldOwnerObject2ForceNonTransientContainer().values()) {
                this.restoreTransientFields(forceNonTransientContainer);
            }
            Object object = objectGraphContainer.getRoot();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private void restoreTransientFields(ForceNonTransientContainer container) {
        Object ownerObject = container.getTransientFieldOwnerObject();
        for (Map.Entry<String, Object> me : container.getTransientFieldName2Value().entrySet()) {
            String qualifiedFieldName = me.getKey();
            Object fieldValue = me.getValue();
            ReflectionUtil.setFieldValue((Object)ownerObject, (String)qualifiedFieldName, (Object)fieldValue);
        }
    }

    private static class ResolvingObjectInputStream
    extends ExtObjectInputStream {
        private final ObjectRefConverter objectRefConverter;

        public ResolvingObjectInputStream(InputStream in, ObjectRefConverter objectRefConverter) throws IOException {
            super(in);
            this.objectRefConverter = (ObjectRefConverter)AssertUtil.assertNotNull((Object)objectRefConverter, (String)"objectRefConverter");
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object object) throws IOException {
            Object result = this.objectRefConverter.convertFromObjectRefIfNeeded(object);
            return result;
        }
    }
}

