/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.net.URL;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Config;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setters;
import org.xml.sax.InputSource;

public class XmlParser {
    public void parse(URL xml, CmdLineParser parser, Object bean) {
        this.parse(new InputSource(xml.toExternalForm()), parser, bean);
    }

    public void parse(InputSource xml, CmdLineParser parser, Object bean) {
        try {
            Config config = Config.parse(xml);
            for (Config.ConfigElement ce : config.options) {
                OptionImpl option = new OptionImpl(ce);
                parser.addOption(Setters.create(parser, this.findMethodOrField(bean, ce.field, ce.method), bean), option);
            }
            for (Config.ConfigElement ce : config.arguments) {
                ArgumentImpl argument = new ArgumentImpl(ce);
                parser.addArgument(Setters.create(parser, this.findMethodOrField(bean, ce.field, ce.method), bean), argument);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problems while reading the args-confguration.", e);
        }
    }

    private AccessibleObject findMethodOrField(Object bean, String field, String method) throws SecurityException, NoSuchFieldException, NoSuchMethodException, ClassNotFoundException {
        AccessibleObject rv;
        if (field != null) {
            rv = bean.getClass().getDeclaredField(field);
        } else {
            String methodName = method.substring(0, method.indexOf("("));
            String[] params = method.substring(method.indexOf("(") + 1, method.indexOf(")")).split(",");
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                String className = params[i];
                if (className.indexOf(46) < 0) {
                    className = "java.lang." + className;
                }
                paramTypes[i] = Class.forName(className);
            }
            rv = bean.getClass().getMethod(methodName, paramTypes);
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationImpl {
        public String[] aliases;
        public Class<? extends OptionHandler> handler;
        public String metaVar;
        public boolean multiValued;
        public boolean required;
        public String usage;
        public Class<? extends Annotation> annotationType;
        public int index;

        protected AnnotationImpl(Config.ConfigElement ce) throws ClassNotFoundException {
            this.aliases = ce.aliases != null ? ce.aliases : new String[]{};
            this.handler = ce.handler != null ? Class.forName(ce.handler) : OptionHandler.class;
            this.metaVar = ce.metavar != null ? ce.metavar : "";
            this.multiValued = ce.multiValued;
            this.required = ce.required;
            this.usage = ce.usage != null ? ce.usage : "";
        }

        public String[] aliases() {
            return this.aliases;
        }

        public Class<? extends OptionHandler> handler() {
            return this.handler;
        }

        public String metaVar() {
            return this.metaVar;
        }

        public boolean multiValued() {
            return this.multiValued;
        }

        public boolean required() {
            return this.required;
        }

        public String usage() {
            return this.usage;
        }

        public Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        public int index() {
            return this.index;
        }
    }

    class ArgumentImpl
    extends AnnotationImpl
    implements Argument {
        protected ArgumentImpl(Config.ConfigElement ce) throws ClassNotFoundException {
            super(ce);
            this.annotationType = Argument.class;
        }
    }

    class OptionImpl
    extends AnnotationImpl
    implements Option {
        public String name;

        protected OptionImpl(Config.ConfigElement ce) throws ClassNotFoundException {
            super(ce);
            this.name = ce.name;
            this.annotationType = Option.class;
        }

        public String name() {
            return this.name;
        }
    }
}

