/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractSetStore
extends AbstractCollectionStore
implements SetStore {
    protected AbstractSetStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    @Override
    public abstract Iterator iterator(ObjectProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ObjectProvider op, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(op, element)) {
            NucleusLogger.DATASTORE.debug((Object)("Attempt to remove element=" + StringUtils.toJVMIDString((Object)element) + " but doesn't exist in this Set."));
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = op.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = false;
        String removeStmt = this.getRemoveStmt(elementToRemove);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeStmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, elementToRemove, jdbcPosition, this.elementMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    modified = (rowsDeleted = sqlControl.executeStatementUpdate(ec, mconn, removeStmt, ps, true))[0] == 1;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"056012", (Object[])new Object[]{removeStmt});
            NucleusLogger.DATASTORE.error((Object)msg, (Throwable)e);
            throw new NucleusDataStoreException(msg, (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (allowDependentField && dependent && !collmd.isEmbeddedElement()) {
            op.getExecutionContext().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        for (Object element : elements) {
            if (this.validateElementForReading(op, element)) continue;
            NucleusLogger.DATASTORE.debug((Object)("AbstractSetStore::removeAll element=" + element + " doesn't exist in this Set."));
            return false;
        }
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    sqlControl.processStatementsForConnection(mconn);
                }
                catch (SQLException e) {
                    throw new MappedDatastoreException("SQLException", e);
                }
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    try {
                        int[] rc = this.internalRemove(op, mconn, batched, element, !batched || batched && !iter.hasNext());
                        if (rc == null) continue;
                        for (int i = 0; i < rc.length; ++i) {
                            if (rc[i] <= 0) continue;
                            modified = true;
                        }
                    }
                    catch (MappedDatastoreException mde) {
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error((Object)"Exception in remove", (Throwable)mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)"Exception performing removeAll on set backing store", (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = Localiser.msg((String)"056012", (Object[])new Object[]{((Exception)exceptions.get(0)).getMessage()});
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), op.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] internalRemove(ObjectProvider op, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt(element);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
            jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
            }
            nArray = sqlControl.executeStatementUpdate(ec, conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException("SQLException", e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }
}

