/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.subshare.crypto.Cipher;
import org.subshare.crypto.CipherOperationMode;

public abstract class AbstractCipher
implements Cipher {
    private final String transformation;
    private CipherOperationMode mode;
    private CipherParameters parameters;

    protected AbstractCipher(String transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("transformation == null");
        }
        this.transformation = transformation;
    }

    @Override
    public final String getTransformation() {
        return this.transformation;
    }

    @Override
    public byte[] doFinal(byte[] in) throws DataLengthException, IllegalStateException, CryptoException {
        byte[] out = new byte[this.getOutputSize(in.length)];
        int outOff = this.update(in, 0, in.length, out, 0);
        if ((outOff += this.doFinal(out, outOff)) == out.length) {
            return out;
        }
        byte[] truncOut = new byte[outOff];
        System.arraycopy(out, 0, truncOut, 0, truncOut.length);
        return truncOut;
    }

    @Override
    public final void init(CipherOperationMode mode, CipherParameters parameters) throws IllegalArgumentException {
        if (mode == null) {
            throw new IllegalArgumentException("mode == null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters == null");
        }
        this.mode = mode;
        this.parameters = parameters;
        this._init(mode, parameters);
    }

    @Override
    public CipherOperationMode getMode() {
        return this.mode;
    }

    @Override
    public CipherParameters getParameters() {
        return this.parameters;
    }

    protected abstract void _init(CipherOperationMode var1, CipherParameters var2) throws IllegalArgumentException;
}

