/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.createrepo.selectserver;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import org.subshare.core.server.Server;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.createrepo.selectserver.ServerListItem;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class CreateRepoSelectServerPane
extends WizardPageContentGridPane {
    private final CreateRepoData createRepoData;
    @FXML
    private TableView<ServerListItem> tableView;

    public CreateRepoSelectServerPane(CreateRepoData createRepoData) {
        this.createRepoData = (CreateRepoData)AssertUtil.assertNotNull((Object)createRepoData, (String)"createRepoData");
        FxmlUtil.loadDynamicComponentFxml(CreateRepoSelectServerPane.class, this);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getSelectionModel().selectedItemProperty().addListener(observable -> this.onSelectionChanged());
        this.populateTableView();
        this.updateComplete();
    }

    private void populateTableView() {
        HashMap<Server, ServerListItem> server2ServerListItem = new HashMap<Server, ServerListItem>();
        for (Server server : ServerRegistryLs.getServerRegistry().getServers()) {
            ServerListItem item = new ServerListItem(server);
            server2ServerListItem.put(server, item);
            this.tableView.getItems().add((Object)item);
        }
        ServerListItem serverListItem = (ServerListItem)server2ServerListItem.get(this.createRepoData.getServer());
        this.tableView.getSelectionModel().clearSelection();
        this.tableView.getSelectionModel().select((Object)serverListItem);
    }

    private void onSelectionChanged() {
        ServerListItem serverListItem = (ServerListItem)this.tableView.getSelectionModel().selectedItemProperty().get();
        Server server = serverListItem == null ? null : serverListItem.getServer();
        this.createRepoData.setServer(server);
        this.updateComplete();
    }

    @Override
    protected boolean isComplete() {
        return this.createRepoData.getServer() != null;
    }

    public void requestFocus() {
        super.requestFocus();
        this.tableView.requestFocus();
    }
}

