/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.invitation.accept;

import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.io.Streams;
import org.subshare.core.user.UserRepoInvitationToken;
import org.subshare.gui.invitation.accept.AcceptInvitationData;
import org.subshare.gui.ls.LockerSyncDaemonLs;
import org.subshare.gui.ls.PgpSyncDaemonLs;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.ls.ServerRepoManagerLs;

public class AcceptInvitationManager {
    public void acceptInvitation(AcceptInvitationData acceptInvitationData) {
        AssertUtil.assertNotNull((Object)acceptInvitationData, (String)"acceptInvitationData");
        File invitationFile = (File)AssertUtil.assertNotNull((Object)acceptInvitationData.getInvitationFile(), (String)"acceptInvitationData.invitationFile");
        UserRepoInvitationToken userRepoInvitationToken = this.readUserRepoInvitationToken(invitationFile);
        File directory = (File)AssertUtil.assertNotNull((Object)acceptInvitationData.getCheckOutDirectory(), (String)"acceptInvitationData.checkOutDirectory");
        ServerRepoManagerLs.getServerRepoManager().checkOutRepository(directory, userRepoInvitationToken);
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(directory);
        PgpSyncDaemonLs.getPgpSyncDaemon().sync();
        LockerSyncDaemonLs.getLockerSyncDaemon().sync();
    }

    private UserRepoInvitationToken readUserRepoInvitationToken(File file) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream((int)file.length());
            try (InputStream in = StreamUtil.castStream((IInputStream)file.createInputStream());){
                Streams.pipeAll((InputStream)in, (OutputStream)bout);
            }
            UserRepoInvitationToken result = new UserRepoInvitationToken(bout.toByteArray());
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

