/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.imp.fromserver;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableMap;
import javafx.scene.Parent;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.TempImportKeysResult;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;
import org.subshare.gui.pgp.imp.fromserver.CertifyPgpKeyWizardPage;
import org.subshare.gui.pgp.imp.fromserver.ImportPgpKeyFromServerData;
import org.subshare.gui.pgp.imp.fromserver.SearchResultPane;
import org.subshare.gui.wizard.WizardPage;

public class SearchResultWizardPage
extends WizardPage {
    private final ImportPgpKeyFromServerData importPgpKeyFromServerData;
    private final Map<PgpKeyId, CertifyPgpKeyWizardPage> pgpKeyId2CertifyPgpKeyWizardPage = new HashMap<PgpKeyId, CertifyPgpKeyWizardPage>();
    private final ObservableMap<PgpKeyId, CertifyPgpKeyData> pgpKeyId2CertifyPgpKeyData;
    private SearchResultPane searchResultPane;

    public SearchResultWizardPage(ImportPgpKeyFromServerData importPgpKeyFromServerData) {
        super("Search result");
        this.importPgpKeyFromServerData = (ImportPgpKeyFromServerData)AssertUtil.assertNotNull((Object)importPgpKeyFromServerData, (String)"importPgpKeyFromServerData");
        this.pgpKeyId2CertifyPgpKeyData = importPgpKeyFromServerData.getPgpKeyId2CertifyPgpKeyData();
        this.shownRequired.set(true);
        importPgpKeyFromServerData.queryStringProperty().addListener(observable -> this.shown.set(false));
        importPgpKeyFromServerData.tempImportKeysResultProperty().addListener(observable -> this.updateCertifyPgpKeyWizardPages());
        importPgpKeyFromServerData.getSelectedPgpKeyIds().addListener(observable -> this.updateCertifyPgpKeyWizardPages());
    }

    @Override
    protected void onShown() {
        super.onShown();
        this.searchResultPane.searchAsync();
    }

    @Override
    protected Parent createContent() {
        this.searchResultPane = new SearchResultPane(this.importPgpKeyFromServerData);
        return this.searchResultPane;
    }

    protected void updateCertifyPgpKeyWizardPages() {
        Pgp tempPgp;
        for (CertifyPgpKeyData certifyPgpKeyData : this.pgpKeyId2CertifyPgpKeyData.values()) {
            certifyPgpKeyData.setPgp(null);
            certifyPgpKeyData.setPgpKey(null);
        }
        TempImportKeysResult tempImportKeysResult = this.importPgpKeyFromServerData.getTempImportKeysResult();
        Pgp pgp = tempPgp = tempImportKeysResult == null ? null : tempImportKeysResult.getTempPgp();
        if (tempPgp == null) {
            this.setNextPage(null);
            return;
        }
        ArrayList<CertifyPgpKeyWizardPage> certifyPgpKeyWizardPages = new ArrayList<CertifyPgpKeyWizardPage>();
        for (PgpKeyId pgpKeyId : this.importPgpKeyFromServerData.getSelectedPgpKeyIds()) {
            PgpKey pgpKey = tempPgp.getPgpKey(pgpKeyId);
            AssertUtil.assertNotNull((Object)pgpKey, (String)("tempPgp.getPgpKey(" + pgpKeyId + ")"));
            CertifyPgpKeyData certifyPgpKeyData = (CertifyPgpKeyData)this.pgpKeyId2CertifyPgpKeyData.get((Object)pgpKeyId);
            if (certifyPgpKeyData == null) {
                certifyPgpKeyData = new CertifyPgpKeyData();
                certifyPgpKeyData.setSkip(true);
                this.pgpKeyId2CertifyPgpKeyData.put((Object)pgpKeyId, (Object)certifyPgpKeyData);
            }
            certifyPgpKeyData.setPgp(tempPgp);
            certifyPgpKeyData.setPgpKey(pgpKey);
            CertifyPgpKeyWizardPage cpkwp = this.pgpKeyId2CertifyPgpKeyWizardPage.get(pgpKeyId);
            if (cpkwp == null) {
                cpkwp = new CertifyPgpKeyWizardPage(certifyPgpKeyData);
                this.pgpKeyId2CertifyPgpKeyWizardPage.put(pgpKeyId, cpkwp);
            }
            certifyPgpKeyWizardPages.add(cpkwp);
        }
        WizardPage lastWizardPage = this;
        for (CertifyPgpKeyWizardPage cpkwp : certifyPgpKeyWizardPages) {
            lastWizardPage.setNextPage(cpkwp);
            lastWizardPage = cpkwp;
        }
        lastWizardPage.setNextPage(null);
    }
}

