/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.UrlEncoder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlUtil {
    private static final Logger logger = LoggerFactory.getLogger(UrlUtil.class);
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_JAR = "jar";

    private UrlUtil() {
    }

    public static URL canonicalizeURL(URL url) {
        if (url == null) {
            return null;
        }
        URL result = url;
        String query = url.getQuery();
        if (query != null && query.isEmpty()) {
            query = null;
            result = null;
        }
        String path = url.getPath();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
            result = null;
        }
        int duplicateSlashIndex = path.indexOf("//");
        while (duplicateSlashIndex >= 0) {
            path = path.substring(0, duplicateSlashIndex) + path.substring(duplicateSlashIndex + 1);
            duplicateSlashIndex = path.indexOf("//");
            result = null;
        }
        if (result == null) {
            String file;
            String string = file = query == null ? path : path + '?' + query;
            if (StringUtil.isEmpty(url.getHost()) && StringUtil.isEmpty(file)) {
                file = "/";
            }
            try {
                result = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static File getFile(URL url) {
        AssertUtil.assertNotNull(url, "url");
        if (!url.getProtocol().equalsIgnoreCase(PROTOCOL_FILE)) {
            throw new IllegalStateException("url does not reference a local file, i.e. it does not start with 'file:': " + url);
        }
        try {
            return OioFileFactory.createFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL appendEncodedPath(URL url, String path) {
        AssertUtil.assertNotNull(url, "url");
        if (path == null || path.isEmpty()) {
            return url;
        }
        return UrlUtil.appendEncodedPath(url, Collections.singletonList(path));
    }

    public static URL appendNonEncodedPath(URL url, String path) {
        AssertUtil.assertNotNull(url, "url");
        if (path == null || path.isEmpty()) {
            return url;
        }
        String[] pathSegments = path.split("/");
        ArrayList<String> encodedPathSegments = new ArrayList<String>(pathSegments.length);
        for (String pathSegment : pathSegments) {
            encodedPathSegments.add(UrlEncoder.encode(pathSegment));
        }
        return UrlUtil.appendEncodedPath(url, encodedPathSegments);
    }

    private static URL appendEncodedPath(URL url, List<String> pathSegments) {
        AssertUtil.assertNotNull(url, "url");
        if (pathSegments == null || pathSegments.isEmpty()) {
            return url;
        }
        try {
            StringBuilder urlString = new StringBuilder(url.toExternalForm());
            for (String ps : pathSegments) {
                if (ps == null || ps.isEmpty()) continue;
                if (ps.startsWith("/") && UrlUtil.getLastChar(urlString) == '/') {
                    urlString.append(ps.substring(1));
                    continue;
                }
                if (!ps.startsWith("/") && UrlUtil.getLastChar(urlString) != '/') {
                    urlString.append('/').append(ps);
                    continue;
                }
                urlString.append(ps);
            }
            return new URL(urlString.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static char getLastChar(StringBuilder stringBuilder) {
        AssertUtil.assertNotNull(stringBuilder, "stringBuilder");
        int index = stringBuilder.length() - 1;
        if (index < 0) {
            return '\u0000';
        }
        return stringBuilder.charAt(index);
    }

    public static final URI urlToUri(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileFromJarUrl(URL url) {
        URL fileUrl = UrlUtil.getFileUrlFromJarUrl(url);
        return UrlUtil.getFile(fileUrl);
    }

    public static URL getFileUrlFromJarUrl(URL url) {
        AssertUtil.assertNotNull(url, "url");
        logger.debug("getFileUrlFromJarUrl: url={}", (Object)url);
        if (!url.getProtocol().equalsIgnoreCase(PROTOCOL_JAR)) {
            throw new IllegalArgumentException("url is not starting with 'jar:': " + url);
        }
        String urlStrWithoutJarPrefix = url.getFile();
        int exclamationMarkIndex = urlStrWithoutJarPrefix.indexOf(33);
        if (exclamationMarkIndex >= 0) {
            urlStrWithoutJarPrefix = urlStrWithoutJarPrefix.substring(0, exclamationMarkIndex);
        }
        try {
            URL urlWithoutJarPrefixAndSuffix = new URL(urlStrWithoutJarPrefix);
            logger.debug("getFileUrlFromJarUrl: urlWithoutJarPrefixAndSuffix={}", (Object)urlWithoutJarPrefixAndSuffix);
            return urlWithoutJarPrefixAndSuffix;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

