/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core;

import co.codewizards.cloudstore.core.TimeUnit;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class TimePeriod {
    private final long millis;
    private static final String delim = " \t\u202f\u2009\r\n";
    private static final Set<Character> delimChars = new HashSet<Character>(" \t\u202f\u2009\r\n".length());

    public TimePeriod(String string) throws ParseException {
        HashMap<TimeUnit, Long> timeUnitMap = new HashMap<TimeUnit, Long>();
        StringTokenizer st = new StringTokenizer(string, delim, true);
        int offset = 0;
        long value = Long.MIN_VALUE;
        String timeUnitString = null;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!TimePeriod.isDelim(tok)) {
                if (value == Long.MIN_VALUE) {
                    String[] numberAndTimeUnit = TimePeriod.splitNumberAndTimeUnit(tok);
                    try {
                        value = Long.parseLong(numberAndTimeUnit[0]);
                    }
                    catch (NumberFormatException x) {
                        throw new ParseException(String.format("The text '%s' at position %d (0-based) of the input '%s' is not a valid integer!", StringUtil.isEmpty(numberAndTimeUnit[0]) ? tok : numberAndTimeUnit[0], offset, string), offset);
                    }
                    timeUnitString = numberAndTimeUnit[1];
                } else {
                    timeUnitString = tok;
                }
                if (!StringUtil.isEmpty(timeUnitString)) {
                    TimeUnit timeUnit;
                    try {
                        timeUnit = TimeUnit.valueOf(timeUnitString);
                    }
                    catch (Exception x) {
                        throw new ParseException(String.format("The text '%s' at position %d (0-based) of the input '%s' is not a valid time unit!", timeUnitString, offset, string), offset);
                    }
                    timeUnitMap.put(timeUnit, value);
                    value = Long.MIN_VALUE;
                    timeUnitString = null;
                }
            }
            offset += tok.length();
        }
        if (value != Long.MIN_VALUE) {
            throw new ParseException(String.format("The input '%s' is missing a time unit at its end!", string), offset);
        }
        long millis = 0L;
        for (Map.Entry me : timeUnitMap.entrySet()) {
            millis += ((TimeUnit)((Object)me.getKey())).toMillis((Long)me.getValue());
        }
        this.millis = millis;
    }

    private static boolean isDelim(String token) {
        if (token == null || token.isEmpty()) {
            return true;
        }
        for (char c : token.toCharArray()) {
            if (delimChars.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    private static String[] splitNumberAndTimeUnit(String token) {
        if (token == null || token.isEmpty()) {
            return new String[]{token, null};
        }
        int index = 0;
        while (Character.isDigit(token.charAt(index))) {
            if (++index < token.length()) continue;
            return new String[]{token, null};
        }
        return new String[]{token.substring(0, index), token.substring(index)};
    }

    public TimePeriod(long millis) {
        this.millis = millis;
    }

    public String toString() {
        return this.toString(TimeUnit.getUniqueTimeUnitsOrderedByLengthDesc());
    }

    public String toString(TimeUnit ... timeUnits) {
        return this.toString((Collection<TimeUnit>)(timeUnits == null ? null : new HashSet<TimeUnit>(Arrays.asList(timeUnits))));
    }

    public String toString(Collection<TimeUnit> timeUnits) {
        StringBuilder sb = new StringBuilder();
        Map<TimeUnit, Long> timeUnitMap = this.toTimeUnitMap(timeUnits);
        for (Map.Entry<TimeUnit, Long> me : timeUnitMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(me.getValue()).append('\u202f').append((Object)me.getKey());
        }
        return sb.toString();
    }

    public long toMillis() {
        return this.millis;
    }

    public Map<TimeUnit, Long> toTimeUnitMap() {
        return this.toTimeUnitMap((Collection<TimeUnit>)null);
    }

    public Map<TimeUnit, Long> toTimeUnitMap(TimeUnit ... timeUnits) {
        return this.toTimeUnitMap((Collection<TimeUnit>)(timeUnits == null ? null : new HashSet<TimeUnit>(Arrays.asList(timeUnits))));
    }

    public Map<TimeUnit, Long> toTimeUnitMap(Collection<TimeUnit> timeUnits) {
        if (timeUnits == null) {
            timeUnits = TimeUnit.getUniqueTimeUnitsOrderedByLengthAsc();
        }
        LinkedHashMap<TimeUnit, Long> result = new LinkedHashMap<TimeUnit, Long>();
        long remaining = this.millis;
        for (TimeUnit timeUnit : timeUnits) {
            long v = remaining / timeUnit.toMillis();
            remaining -= v * timeUnit.toMillis();
            if (v == 0L) continue;
            result.put(timeUnit, v);
        }
        if (remaining != 0L) {
            result.put(TimeUnit.ms, remaining);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis ^ this.millis >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimePeriod other = (TimePeriod)obj;
        return this.millis == other.millis;
    }

    static {
        for (char c : delim.toCharArray()) {
            delimChars.add(Character.valueOf(c));
        }
    }
}

