/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import java.net.URL;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_RepositoryDto/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class RepositoryDtoService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryDtoService.class);
    @PathParam(value="repositoryName")
    private String repositoryName;

    public RepositoryDtoService() {
        logger.debug("<init>: created new instance");
    }

    @GET
    public RepositoryDto getRepositoryDto() {
        URL localRootURL = LocalRepoRegistryImpl.getInstance().getLocalRootURLForRepositoryNameOrFail(this.repositoryName);
        RepoTransportFactoryRegistry repoTransportRegistry = RepoTransportFactoryRegistry.getInstance();
        RepoTransportFactory repoTransportFactory = repoTransportRegistry.getRepoTransportFactory(localRootURL);
        try (RepoTransport repoTransport = repoTransportFactory.createRepoTransport(localRootURL, null);){
            RepositoryDto repositoryDto;
            RepositoryDto repositoryDto2 = repositoryDto = repoTransport.getRepositoryDto();
            return repositoryDto2;
        }
    }
}

