/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@FetchGroups(value={@FetchGroup(name="CryptoKeyDto", members={@Persistent(name="signature")})})
public class CryptoKeyDeactivation
extends Entity
implements WriteProtected,
Persistable {
    @Persistent(mappedBy="cryptoKeyDeactivation", nullValue=NullValue.EXCEPTION)
    private CryptoKey cryptoKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoKey getCryptoKey() {
        return CryptoKeyDeactivation.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)CryptoKeyDeactivation.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoKeyDeactivation.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public String getSignedDataType() {
        return "CryptoKeyDeactivation";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            return InputStreamSource.Helper.createInputStreamSource((Uid)CryptoKeyDeactivation.dnGetcryptoKey(this).getCryptoKeyId()).createInputStream();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CryptoKeyDeactivation.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoKeyDeactivation.dnGetsignature(this), (Object)signature)) {
            CryptoKeyDeactivation.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        CryptoKey ck = (CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)CryptoKeyDeactivation.dnGetcryptoKey(this)), (String)"cryptoKey"));
        CryptoKeyRole cryptoKeyRole = (CryptoKeyRole)AssertUtil.assertNotNull((Object)ck.getCryptoKeyRole(), (String)"cryptoKey.cryptoKeyRole");
        CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)ck.getCryptoRepoFile()), (String)"cryptoKey.cryptoRepoFile"));
        switch (cryptoKeyRole) {
            case backlinkKey: 
            case dataKey: {
                return null;
            }
        }
        return (Uid)AssertUtil.assertNotNull((Object)cryptoRepoFile.getCryptoRepoFileId(), (String)"cryptoRepoFile.cryptoRepoFileId");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.grant;
    }

    static {
        dnFieldNames = CryptoKeyDeactivation.__dnFieldNamesInit();
        dnFieldTypes = CryptoKeyDeactivation.__dnFieldTypesInit();
        dnFieldFlags = CryptoKeyDeactivation.__dnFieldFlagsInit();
        dnInheritedFieldCount = CryptoKeyDeactivation.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CryptoKeyDeactivation.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CryptoKeyDeactivation.___dn$loadClass("org.subshare.local.persistence.CryptoKeyDeactivation"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CryptoKeyDeactivation());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoKeyDeactivation result = new CryptoKeyDeactivation();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoKeyDeactivation result = new CryptoKeyDeactivation();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoKeyDeactivation obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 1: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoKeyDeactivation)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoKeyDeactivation");
        }
        CryptoKeyDeactivation other = (CryptoKeyDeactivation)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoKey", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CryptoKeyDeactivation.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), CryptoKeyDeactivation.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 2 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CryptoKeyDeactivation.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CryptoKeyDeactivation o = (CryptoKeyDeactivation)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoKey dnGetcryptoKey(CryptoKeyDeactivation objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(CryptoKeyDeactivation objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(CryptoKeyDeactivation objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoKeyDeactivation objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

