/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.transport;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.CopyModificationDto;
import co.codewizards.cloudstore.core.dto.DeleteModificationDto;
import co.codewizards.cloudstore.core.dto.ModificationDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.dto.DeleteModificationDtoConverter;
import co.codewizards.cloudstore.local.dto.RepoFileDtoConverter;
import co.codewizards.cloudstore.local.dto.RepositoryDtoConverter;
import co.codewizards.cloudstore.local.persistence.CopyModification;
import co.codewizards.cloudstore.local.persistence.DeleteModification;
import co.codewizards.cloudstore.local.persistence.DeleteModificationDao;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepo;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepoDao;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.Modification;
import co.codewizards.cloudstore.local.persistence.ModificationDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetDtoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetDtoBuilder.class);
    private final LocalRepoTransaction transaction;
    private final RepoTransport repoTransport;
    private final UUID clientRepositoryId;
    private static final UUID NULL_UUID = new UUID(0L, 0L);
    private final String pathPrefix;
    private LocalRepository localRepository;
    private RemoteRepository remoteRepository;
    private LastSyncToRemoteRepo lastSyncToRemoteRepo;
    private Collection<Modification> modifications;
    private boolean resyncMode;

    protected ChangeSetDtoBuilder(LocalRepoTransaction transaction, RepoTransport repoTransport) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
        this.repoTransport = (RepoTransport)AssertUtil.assertNotNull((Object)repoTransport, (String)"repoTransport");
        this.clientRepositoryId = (UUID)AssertUtil.assertNotNull((Object)repoTransport.getClientRepositoryId(), (String)"clientRepositoryId");
        this.pathPrefix = (String)AssertUtil.assertNotNull((Object)repoTransport.getPathPrefix(), (String)"pathPrefix");
    }

    public static ChangeSetDtoBuilder create(LocalRepoTransaction transaction, RepoTransport repoTransport) {
        return (ChangeSetDtoBuilder)ObjectFactoryUtil.createObject(ChangeSetDtoBuilder.class, (Object[])new Object[]{transaction, repoTransport});
    }

    public void prepareBuildChangeSetDto(Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced) {
        this.localRepository = null;
        this.remoteRepository = null;
        this.lastSyncToRemoteRepo = null;
        this.modifications = null;
        LocalRepositoryDao localRepositoryDao = (LocalRepositoryDao)this.transaction.getDao(LocalRepositoryDao.class);
        RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class);
        ModificationDao modificationDao = (ModificationDao)this.transaction.getDao(ModificationDao.class);
        RepoFileDao repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
        this.localRepository = localRepositoryDao.getLocalRepositoryOrFail();
        this.remoteRepository = remoteRepositoryDao.getRemoteRepositoryOrFail(this.clientRepositoryId);
        this.prepareLastSyncToRemoteRepo(lastSyncToRemoteRepoLocalRepositoryRevisionSynced);
    }

    public ChangeSetDto buildChangeSetDto(Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced) {
        Collection<DeleteModification> deleteModifications;
        logger.trace(">>> buildChangeSetDto >>>");
        this.localRepository = null;
        this.remoteRepository = null;
        this.lastSyncToRemoteRepo = null;
        this.modifications = null;
        ChangeSetDto changeSetDto = (ChangeSetDto)ObjectFactoryUtil.createObject(ChangeSetDto.class);
        LocalRepositoryDao localRepositoryDao = (LocalRepositoryDao)this.transaction.getDao(LocalRepositoryDao.class);
        RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class);
        ModificationDao modificationDao = (ModificationDao)this.transaction.getDao(ModificationDao.class);
        RepoFileDao repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
        LastSyncToRemoteRepoDao lastSyncToRemoteRepoDao = (LastSyncToRemoteRepoDao)this.transaction.getDao(LastSyncToRemoteRepoDao.class);
        this.localRepository = localRepositoryDao.getLocalRepositoryOrFail();
        this.remoteRepository = remoteRepositoryDao.getRemoteRepositoryOrFail(this.clientRepositoryId);
        this.lastSyncToRemoteRepo = lastSyncToRemoteRepoDao.getLastSyncToRemoteRepoOrFail(this.remoteRepository);
        logger.trace("localRepositoryId: {}", (Object)this.localRepository.getRepositoryId());
        logger.trace("remoteRepositoryId: {}", (Object)this.remoteRepository.getRepositoryId());
        logger.trace("pathPrefix: {}", (Object)this.pathPrefix);
        changeSetDto.setRepositoryDto(RepositoryDtoConverter.create().toRepositoryDto(this.localRepository));
        logger.info("buildChangeSetDto: localRepositoryId={} remoteRepositoryId={} localRepositoryRevisionSynced={} localRepositoryRevisionInProgress={}", new Object[]{this.localRepository.getRepositoryId(), this.remoteRepository.getRepositoryId(), this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced(), this.lastSyncToRemoteRepo.getLocalRepositoryRevisionInProgress()});
        ((ContextWithPersistenceManager)this.transaction).getPersistenceManager().getFetchPlan().setGroups(new String[]{"default", "ChangeSetDto"});
        this.modifications = modificationDao.getModificationsAfter(this.remoteRepository, this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced());
        changeSetDto.setModificationDtos(this.toModificationDtos(this.modifications));
        if (!this.pathPrefix.isEmpty() && !(deleteModifications = ((DeleteModificationDao)this.transaction.getDao(DeleteModificationDao.class)).getDeleteModificationsForPathOrParentOfPathAfter(this.pathPrefix, this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced(), this.remoteRepository)).isEmpty()) {
            DeleteModificationDto deleteModificationDto = new DeleteModificationDto();
            deleteModificationDto.setId(0L);
            deleteModificationDto.setLocalRevision(this.localRepository.getRevision());
            deleteModificationDto.setPath("");
            changeSetDto.getModificationDtos().add(deleteModificationDto);
        }
        Collection<RepoFile> repoFiles = repoFileDao.getRepoFilesChangedAfterExclLastSyncFromRepositoryId(this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced(), this.resyncMode ? NULL_UUID : this.clientRepositoryId);
        RepoFile pathPrefixRepoFile = null;
        if (!this.pathPrefix.isEmpty()) {
            pathPrefixRepoFile = repoFileDao.getRepoFile(this.getLocalRepoManager().getLocalRoot(), this.getPathPrefixFile());
        }
        Map<Long, RepoFileDto> id2RepoFileDto = this.getId2RepoFileDtoWithParents(pathPrefixRepoFile, repoFiles, this.transaction);
        changeSetDto.setRepoFileDtos(new ArrayList<RepoFileDto>(id2RepoFileDto.values()));
        changeSetDto.setParentConfigPropSetDto(this.buildParentConfigPropSetDto());
        logger.trace("<<< buildChangeSetDto <<<");
        return changeSetDto;
    }

    protected boolean isResyncMode() {
        return this.resyncMode;
    }

    protected void prepareLastSyncToRemoteRepo(Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced) {
        LastSyncToRemoteRepoDao lastSyncToRemoteRepoDao = (LastSyncToRemoteRepoDao)this.transaction.getDao(LastSyncToRemoteRepoDao.class);
        this.lastSyncToRemoteRepo = lastSyncToRemoteRepoDao.getLastSyncToRemoteRepo(this.remoteRepository);
        if (this.lastSyncToRemoteRepo == null) {
            this.lastSyncToRemoteRepo = new LastSyncToRemoteRepo();
            this.lastSyncToRemoteRepo.setRemoteRepository(this.remoteRepository);
            this.lastSyncToRemoteRepo.setLocalRepositoryRevisionSynced(-1L);
        }
        if (lastSyncToRemoteRepoLocalRepositoryRevisionSynced != null) {
            boolean bl = this.resyncMode = lastSyncToRemoteRepoLocalRepositoryRevisionSynced.longValue() != this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced();
            if (this.resyncMode) {
                logger.warn("prepareLastSyncToRemoteRepo: Enabling resyncMode! lastSyncToRemoteRepoLocalRepositoryRevisionSynced={} overwrites lastSyncToRemoteRepo.localRepositoryRevisionSynced={}", (Object)lastSyncToRemoteRepoLocalRepositoryRevisionSynced, (Object)this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced());
                this.lastSyncToRemoteRepo.setLocalRepositoryRevisionSynced(lastSyncToRemoteRepoLocalRepositoryRevisionSynced);
            }
        }
        this.lastSyncToRemoteRepo.setLocalRepositoryRevisionInProgress(this.localRepository.getRevision());
        this.lastSyncToRemoteRepo = lastSyncToRemoteRepoDao.makePersistent(this.lastSyncToRemoteRepo);
    }

    protected ConfigPropSetDto buildParentConfigPropSetDto() {
        logger.trace(">>> buildConfigPropSetDto >>>");
        if (this.pathPrefix.isEmpty()) {
            logger.debug("buildConfigPropSetDto: pathPrefix is empty => returning null.");
            logger.trace("<<< buildConfigPropSetDto <<< null");
            return null;
        }
        List<File> configFiles = this.getExistingConfigFilesAbovePathPrefix();
        if (!this.isFileModifiedAfterLastSync(configFiles) && !this.isConfigFileDeletedAfterLastSync()) {
            logger.trace("<<< buildConfigPropSetDto <<< null");
            return null;
        }
        Properties properties = new Properties();
        for (File configFile : configFiles) {
            try {
                InputStream in = StreamUtil.castStream((IInputStream)configFile.createInputStream());
                Throwable throwable = null;
                try {
                    properties.load(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ConfigPropSetDto result = new ConfigPropSetDto(properties);
        logger.trace("<<< buildConfigPropSetDto <<< {}", (Object)result);
        return result;
    }

    private boolean isConfigFileDeletedAfterLastSync() {
        String searchSuffix = "/" + Config.PROPERTIES_FILE_NAME_FOR_DIRECTORY;
        for (Modification modification : (Collection)AssertUtil.assertNotNull(this.modifications, (String)"modifications")) {
            DeleteModification deleteModification;
            if (!(modification instanceof DeleteModification) || !(deleteModification = (DeleteModification)modification).getPath().endsWith(searchSuffix)) continue;
            logger.trace("isConfigFileDeletedAfterLastSync: returning true, because of deletion: {}", (Object)deleteModification.getPath());
            return true;
        }
        logger.trace("isConfigFileDeletedAfterLastSync: returning false");
        return false;
    }

    protected List<File> getExistingConfigFilesAbovePathPrefix() {
        ArrayList<File> result = new ArrayList<File>();
        File localRoot = this.transaction.getLocalRepoManager().getLocalRoot();
        File dir = this.getPathPrefixFile();
        while (!localRoot.equals(dir)) {
            dir = (File)AssertUtil.assertNotNull((Object)dir.getParentFile(), (String)("dir.parentFile [dir=" + dir + "]"));
            File configFile = dir.createFile(new String[]{Config.PROPERTIES_FILE_NAME_FOR_DIRECTORY});
            if (configFile.isFile()) {
                result.add(configFile);
                logger.trace("getExistingConfigFilesAbovePathPrefix: enlisted configFile: {}", (Object)configFile);
                continue;
            }
            logger.trace("getExistingConfigFilesAbovePathPrefix: skipped non-existing configFile: {}", (Object)configFile);
        }
        File metaDir = localRoot.createFile(new String[]{LocalRepoManager.META_DIR_NAME});
        File parentConfigFile = metaDir.createFile(new String[]{"parent.properties"});
        if (parentConfigFile.isFile()) {
            result.add(parentConfigFile);
            logger.trace("getExistingConfigFilesAbovePathPrefix: enlisted configFile: {}", (Object)parentConfigFile);
        } else {
            logger.trace("getExistingConfigFilesAbovePathPrefix: skipped non-existing configFile: {}", (Object)parentConfigFile);
        }
        Collections.reverse(result);
        return result;
    }

    protected boolean isFileModifiedAfterLastSync(Collection<File> files) {
        AssertUtil.assertNotNull(files, (String)"files");
        AssertUtil.assertNotNull((Object)this.lastSyncToRemoteRepo, (String)"lastSyncToRemoteRepo");
        RepoFileDao repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
        File localRoot = this.transaction.getLocalRepoManager().getLocalRoot();
        for (File file : files) {
            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
            if (repoFile == null) {
                logger.warn("isFileModifiedAfterLastSync: RepoFile not found for (assuming it is new): {}", (Object)file);
                return true;
            }
            if (repoFile.getLocalRevision() <= this.lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced()) continue;
            logger.trace("isFileModifiedAfterLastSync: file modified: {}", (Object)file);
            return true;
        }
        logger.trace("isFileModifiedAfterLastSync: returning false");
        return false;
    }

    protected File getPathPrefixFile() {
        if (this.pathPrefix.isEmpty()) {
            return this.getLocalRepoManager().getLocalRoot();
        }
        return OioFileFactory.createFile((File)this.getLocalRepoManager().getLocalRoot(), (String[])new String[]{this.pathPrefix});
    }

    protected LocalRepoManager getLocalRepoManager() {
        return this.transaction.getLocalRepoManager();
    }

    private List<ModificationDto> toModificationDtos(Collection<Modification> modifications) {
        long startTimestamp = System.currentTimeMillis();
        ArrayList<ModificationDto> result = new ArrayList<ModificationDto>(((Collection)AssertUtil.assertNotNull(modifications, (String)"modifications")).size());
        for (Modification modification : modifications) {
            ModificationDto modificationDto = this.toModificationDto(modification);
            if (modificationDto == null) continue;
            result.add(modificationDto);
        }
        logger.debug("toModificationDtos: Creating {} ModificationDtos took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
        return result;
    }

    private ModificationDto toModificationDto(Modification modification) {
        DeleteModificationDto modificationDto;
        if (modification instanceof CopyModification) {
            CopyModification copyModification = (CopyModification)modification;
            String fromPath = copyModification.getFromPath();
            String toPath = copyModification.getToPath();
            if (!this.isPathUnderPathPrefix(fromPath) || !this.isPathUnderPathPrefix(toPath)) {
                return null;
            }
            fromPath = this.repoTransport.unprefixPath(fromPath);
            toPath = this.repoTransport.unprefixPath(toPath);
            CopyModificationDto copyModificationDto = new CopyModificationDto();
            modificationDto = copyModificationDto;
            copyModificationDto.setFromPath(fromPath);
            copyModificationDto.setToPath(toPath);
        } else if (modification instanceof DeleteModification) {
            DeleteModification deleteModification = (DeleteModification)modification;
            String path = deleteModification.getPath();
            if (!this.isPathUnderPathPrefix(path)) {
                return null;
            }
            path = this.repoTransport.unprefixPath(path);
            modificationDto = DeleteModificationDtoConverter.create().toDeleteModificationDto(deleteModification);
            modificationDto.setPath(path);
        } else {
            throw new IllegalArgumentException("Unknown modification type: " + modification);
        }
        modificationDto.setId(modification.getId());
        modificationDto.setLocalRevision(modification.getLocalRevision());
        return modificationDto;
    }

    private Map<Long, RepoFileDto> getId2RepoFileDtoWithParents(RepoFile pathPrefixRepoFile, Collection<RepoFile> repoFiles, LocalRepoTransaction transaction) {
        AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
        AssertUtil.assertNotNull(repoFiles, (String)"repoFiles");
        RepoFileDtoConverter repoFileDtoConverter = null;
        HashMap<Long, RepoFileDto> entityID2RepoFileDto = new HashMap<Long, RepoFileDto>();
        block0: for (RepoFile repoFile : repoFiles) {
            NormalFile nf;
            RepoFile rf = repoFile;
            if (rf instanceof NormalFile && (nf = (NormalFile)rf).isInProgress() || pathPrefixRepoFile != null && !this.isDirectOrIndirectParent(pathPrefixRepoFile, rf)) continue;
            while (rf != null) {
                RepoFileDto repoFileDto = (RepoFileDto)entityID2RepoFileDto.get(rf.getId());
                if (repoFileDto == null) {
                    if (repoFileDtoConverter == null) {
                        repoFileDtoConverter = RepoFileDtoConverter.create(transaction);
                    }
                    repoFileDto = repoFileDtoConverter.toRepoFileDto(rf, 0);
                    repoFileDto.setNeededAsParent(true);
                    if (pathPrefixRepoFile != null && pathPrefixRepoFile.equals(rf)) {
                        repoFileDto.setParentId(null);
                        repoFileDto.setName("");
                    }
                    entityID2RepoFileDto.put(rf.getId(), repoFileDto);
                }
                if (repoFile == rf) {
                    repoFileDto.setNeededAsParent(false);
                }
                if (pathPrefixRepoFile != null && pathPrefixRepoFile.equals(rf)) continue block0;
                rf = rf.getParent();
            }
        }
        return entityID2RepoFileDto;
    }

    private boolean isDirectOrIndirectParent(RepoFile parentRepoFile, RepoFile repoFile) {
        AssertUtil.assertNotNull((Object)parentRepoFile, (String)"parentRepoFile");
        AssertUtil.assertNotNull((Object)repoFile, (String)"repoFile");
        for (RepoFile rf = repoFile; rf != null; rf = rf.getParent()) {
            if (!parentRepoFile.equals(rf)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPathUnderPathPrefix(String path) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        if (this.pathPrefix.isEmpty()) {
            return true;
        }
        return path.startsWith(this.pathPrefix);
    }
}

