/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.util.Arrays;
import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle.pqc.crypto.qtesla.FederalInformationProcessingStandard202;

public class Sample {
    public static final double[][] EXPONENTIAL_DISTRIBUTION_I = new double[][]{{1.0, 0.9991161986946363, 0.9982331784940199, 0.9973509387078094, 0.9964694786462738, 0.9955887976202911, 0.9947088949413487, 0.9938297699215427, 0.9929514218735767, 0.992073850110762, 0.9911970539470168, 0.9903210326968659, 0.9894457856754392, 0.9885713121984726, 0.9876976115823064, 0.9868246831438854, 0.9859525262007576, 0.9850811400710747, 0.9842105240735907, 0.9833406775276617, 0.9824715997532455, 0.9816032900709009, 0.9807357478017869, 0.9798689722676627, 0.9790029627908872, 0.9781377186944176, 0.97727323930181, 0.9764095239372179, 0.9755465719253926, 0.9746843825916819, 0.9738229552620297, 0.9729622892629759}, {1.0, 0.9721023839216556, 0.944983044826166, 0.9186202706410608, 0.8929929550089316, 0.8680805803894263, 0.8438632016326556, 0.8203214300108653, 0.7974364176955838, 0.7751898426678221, 0.7535638940492431, 0.7325412578425551, 0.7121051030697161, 0.6922390682968472, 0.672927248535071, 0.654154182506783, 0.6359048402671655, 0.6181646111710313, 0.6009192921753629, 0.5841550764681841, 0.5678585424146588, 0.5520166428115665, 0.5366166944415528, 0.5216463679187922, 0.5070936778179309, 0.4929469730784106, 0.4791949276764872, 0.46582653155747855, 0.45283108182098125, 0.4401981741519982, 0.42791769449111755, 0.4159798109370741}, {1.0, 0.4043749658752094, 0.16351911302657673, 0.06612303575006646, 0.026738500324998374, 0.010812380156475492, 0.004372255856804568, 0.0017680308128930314, 7.149473996299383E-4, 2.8910683032792596E-4, 1.1690756464814498E-4, 4.727449246514746E-5, 1.9116621277361847E-5, 7.730283076682497E-6, 3.1259329553391933E-6, 1.2640490321434786E-6, 5.111497842376106E-7, 2.066961765582044E-7, 8.358275934226015E-8, 3.3798775456782285E-8, 1.36673786719602E-8, 5.52674578407747E-9, 2.234877637837284E-9, 9.037285685357202E-10, 3.6544520906208366E-10, 1.4777689394373883E-10, 5.975727644564383E-11, 2.4164346623502672E-11, 9.771456841275623E-12, 3.951332526741911E-12, 1.597819955662865E-12, 6.461183900458996E-13}};
    public static final double[][] EXPONENTIAL_DISTRIBUTION_III_SIZE = new double[][]{{1.0, 0.9930872609369467, 0.9862223078352471, 0.9794048103630199, 0.972634440471881, 0.96591087238116, 0.9592337825622228, 0.9526028497229044, 0.946017754792049, 0.939478180904156, 0.9329838133841335, 0.9265343397321565, 0.9201294496086297, 0.9137688348192543, 0.9074521893001986, 0.9011792091033698, 0.8949495923817894, 0.8887630393750681, 0.8826192523949821, 0.8765179358111483, 0.8704587960367997, 0.8644415415146577, 0.8584658827029032, 0.8525315320612443, 0.8466382040370798, 0.8407856150517594, 0.8349734834869378, 0.8292015296710239, 0.8234694758657234, 0.8177770462526743, 0.8121239669201751, 0.8065099658500041}, {1.0, 0.8009347729043309, 0.6414965104473122, 0.5137968619140387, 0.41151777291607855, 0.3295988939966354, 0.26398721531271385, 0.21143654034613515, 0.16934687742580917, 0.13563580281309806, 0.1086354309238053, 0.08700989419632213, 0.06968924984856113, 0.05581654350133049, 0.04470541059354285, 0.03580611788133411, 0.02867836489387204, 0.02296949967354094, 0.018397071004753615, 0.01473485388729719, 0.011801656852000873, 0.00945235735065216, 0.007570721688055172, 0.006063654255944362, 0.0048565915444551775, 0.0038898130457473016, 0.003115486528435919, 0.002495301495139325, 0.001998573736337253, 0.0016007272016458378, 0.0012820780777319943, 0.001026860914033896}, {1.0, 8.224486129860722E-4, 6.76421721002714E-7, 5.563221062323341E-10, 4.575463446442734E-13, 3.763083565295301E-16, 3.094942858827804E-19, 2.5454314615140764E-22, 2.0934865749733626E-25, 1.721785129891805E-28, 1.4160797919395592E-31, 1.1646528607582962E-34, 9.57867129940922E-38, 7.87796492444861E-41, 6.479221325265687E-44, 5.328826592194545E-47, 4.382686039593701E-50, 3.6045340544172612E-53, 2.96454403351654E-56, 2.4381851285018142E-59, 2.0052819771395856E-62, 1.6492413807444208E-65, 1.3564162860724833E-68, 1.1155826931120333E-71, 9.17509438621259E-75, 7.546043651956841E-78, 6.206233135084259E-81, 5.104307833818251E-84, 4.198030898177764E-87, 3.4526646894789767E-90, 2.8396392849679724E-93, 2.3354573913026706E-96}};
    public static final double[][] EXPONENTIAL_DISTRIBUTION_III_SPEED = new double[][]{{1.0, 0.9951980443443538, 0.9904191474668262, 0.9856631986401876, 0.980930087668915, 0.9762197048866396, 0.9715319411536059, 0.9668666878541423, 0.9622238368941451, 0.9576032806985737, 0.9530049122089577, 0.9484286248809173, 0.9438743126816935, 0.9393418700876924, 0.9348311920820395, 0.9303421741521466, 0.9258747122872905, 0.9214287029762026, 0.9170040432046712, 0.9126006304531541, 0.9082183626944031, 0.903857138391101, 0.8995168564935077, 0.8951974164371195, 0.8908987181403393, 0.8866206620021573, 0.8823631488998432, 0.8781260801866497, 0.8739093576895269, 0.8697128837068475, 0.8655365610061431, 0.8613802928218509}, {1.0, 0.8572439828530728, 0.7348672461377994, 0.6299605249474366, 0.540029869446153, 0.46293735614364523, 0.3968502629920499, 0.3401975000435942, 0.29163225989402913, 0.25, 0.2143109957132682, 0.18371681153444985, 0.15749013123685915, 0.13500746736153826, 0.11573433903591131, 0.09921256574801247, 0.08504937501089856, 0.07290806497350728, 0.0625, 0.05357774892831705, 0.04592920288361246, 0.03937253280921479, 0.033751866840384566, 0.028933584758977827, 0.02480314143700312, 0.02126234375272464, 0.01822701624337682, 0.015625, 0.013394437232079262, 0.011482300720903116, 0.009843133202303697, 0.008437966710096141}, {1.0, 0.007233396189744457, 5.232202043780962E-5, 3.784659032745837E-7, 2.7375938226945676E-9, 1.9802100726146846E-11, 1.4323643994144654E-13, 1.03608591890502E-15, 7.494419938055456E-18, 5.421010862427522E-20, 3.921231931684655E-22, 2.8363824113752076E-24, 2.0516677727099623E-26, 1.4840525849741735E-28, 1.0734740313532598E-30, 7.764862968180291E-33, 5.616633020792314E-35, 4.062733189179202E-37, 2.938735877055719E-39, 2.125704089576017E-41, 1.537605986206337E-43, 1.1122113281953186E-45, 8.045065183558638E-48, 5.819314384499884E-50, 4.209340649576657E-52, 3.0447828615984243E-54, 2.2024120749685265E-56, 1.5930919111324523E-58, 1.1523464959898195E-60, 8.335378753358135E-63, 6.029309691461764E-65, 4.3612385749008845E-67}};
    public static final double[][] EXPONENTIAL_DISTRIBUTION_P = new double[][]{{1.0, 0.9930924954370359, 0.9862327044933592, 0.9794202975869268, 0.9726549474122855, 0.9659363289248456, 0.9592641193252643, 0.9526379980439373, 0.9460576467255959, 0.9395227492140118, 0.9330329915368074, 0.9265880618903709, 0.9201876506248751, 0.9138314502294005, 0.9075191553171609, 0.9012504626108302, 0.8950250709279725, 0.8888426811665702, 0.8827029962906549, 0.8766057213160351, 0.8705505632961241, 0.8645372313078652, 0.8585654364377537, 0.8526348917679567, 0.8467453123625271, 0.8408964152537145, 0.8350879194283694, 0.8293195458144417, 0.8235910172675731, 0.8179020585577811, 0.8122523963562355, 0.8066417592221263}, {1.0, 0.8010698775896221, 0.6417129487814521, 0.5140569133280333, 0.41179550863378656, 0.32987697769322355, 0.26425451014034507, 0.2116863280906318, 0.16957554093095897, 0.13584185781575725, 0.10881882041201552, 0.08717147914690034, 0.06983044612951375, 0.05593906693299828, 0.0448111015004946, 0.03589682359365735, 0.028755864082027346, 0.023035456520173456, 0.01845301033483641, 0.014782150730087436, 0.011841535675862484, 0.009485897534336304, 0.007598866776658481, 0.0060872232785976555, 0.004876291206646921, 0.00390625, 0.0031291792093344614, 0.0025066912061775474, 0.00200803481768763, 0.0016085762056007287, 0.0012885819441141545, 0.001032244180235723}, {1.0, 8.268997191040304E-4, 6.837631454543244E-7, 5.654035529098692E-10, 4.675320390815916E-13, 3.866021117887027E-16, 3.196811776431032E-19, 2.643442759959277E-22, 2.185862075677909E-25, 1.807488736378216E-28, 1.4946119283948456E-31, 1.2358941837592312E-34, 1.0219605533928131E-37, 8.450588945359167E-41, 6.987789625181121E-44, 5.778201278220326E-47, 4.777993013886938E-50, 3.9509210810641284E-53, 3.26701553213412E-56, 2.701494225830208E-59, 2.2338648165001596E-62, 1.8471821892803583E-65, 1.5274344334498962E-68, 1.263035103969543E-71, 1.044403372690945E-74, 8.636168555094445E-78, 7.1412453523426565E-81, 5.905093775905105E-84, 4.882920384578891E-87, 4.037685494415629E-90, 3.3387610011627014E-93, 2.760820534016929E-96}};
    public static final long[][] CUMULATIVE_DISTRIBUTION_TABLE_I = new long[][]{{0x200000000000000L, 0L}, {0x300000000000000L, 0L}, {0x320000000000000L, 0L}, {225461456345235456L, 0L}, {225463655368491008L, 0L}, {225463659663458304L, 0L}, {225463659665555456L, 0L}, {225463659665555712L, 0L}, {225463659665555712L, 0x200000000000000L}, {225463659665555712L, 0x200010000000000L}, {225463659665555712L, 0x200010000200000L}, {225463659665555712L, 0x200010000200001L}};
    public static final long[][] CUMULATIVE_DISTRIBUTION_TABLE_III = new long[][]{{0x20000000000L, 0L, 0L}, {0x30000000000L, 0L, 0L}, {0x32000000000L, 0L, 0L}, {3440268804096L, 0L, 0L}, {3440302358528L, 0L, 0L}, {3440302424064L, 0L, 0L}, {3440302424096L, 0L, 0L}, {3440302424096L, 0x100000000000000L, 0L}, {3440302424096L, 0x100020000000000L, 0L}, {3440302424096L, 0x100020001000000L, 0L}, {3440302424096L, 0x100020001000020L, 0L}, {3440302424096L, 0x100020001000020L, 0x1000000000000L}, {3440302424096L, 0x100020001000020L, 0x1000002000000L}, {3440302424096L, 0x100020001000020L, 0x1000002000001L}};
    private CommonFunction function = new CommonFunction();
    private FederalInformationProcessingStandard202 fips = new FederalInformationProcessingStandard202();

    public long modulus7(long number) {
        long temporary = number;
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            temporary = temporary % 7L + (temporary >> 3);
        }
        return temporary - 7L >> 3 & temporary;
    }

    public void sampleY(long[] Y, byte[] seed, short seedOffset, int nonce, short n, int b, short bBit) {
        int position = 0;
        short numberOfByte = (short)((bBit + 1 + 7) / 8);
        byte[] buffer = new byte[n * numberOfByte];
        short bufferOffset = 0;
        short dualModeSampler = (short)(nonce << 8);
        this.fips.customizableSecureHashAlgorithmKECCAK128Simple(buffer, bufferOffset, (short)(n * numberOfByte), dualModeSampler, seed, seedOffset, 32);
        for (short i = 0; i < n; i = (short)(i + 1)) {
            Y[i] = this.function.load32(buffer, position) & (1 << bBit + 1) - 1;
            short s = i;
            Y[s] = Y[s] - (long)b;
            position = (short)(position + numberOfByte);
        }
    }

    private int bernoulli(long result, long fractionOfExponent, double[][] exponentialDistribution) {
        double bernoulliParameter = 4.611686018427388E18;
        long i = 0L;
        long j = fractionOfExponent;
        while (i < 3L) {
            bernoulliParameter *= exponentialDistribution[(int)i][(int)(j & 0x1FL)];
            ++i;
            j >>= 5;
        }
        return (int)((result & 0x3FFFFFFFFFFFFFFFL) - Math.round(bernoulliParameter) >>> 63);
    }

    public void polynomialGaussSamplerI(long[] data, byte[] seed, short seedOffset, int nonce, short n, double xi, double[][] exponentialDistribution) {
        byte[] seedExpander = new byte[n * 64 / 8];
        short seedExpanderOffset = 0;
        short domainSeparator = (short)(nonce << 8);
        int j = 0;
        short s = domainSeparator;
        domainSeparator = (short)(domainSeparator + 1);
        this.fips.customizableSecureHashAlgorithmKECCAK128Simple(seedExpander, seedExpanderOffset, (short)(n * 64 / 8), s, seed, seedOffset, 32);
        for (short index = 0; index < n; index = (short)(index + 1)) {
            int bitRemained;
            long randomBit;
            long sign;
            long k;
            if (j + 46 > n) {
                short s2 = domainSeparator;
                domainSeparator = (short)(domainSeparator + 1);
                this.fips.customizableSecureHashAlgorithmKECCAK128Simple(seedExpander, seedExpanderOffset, (short)(n * 64 / 8), s2, seed, seedOffset, 32);
                j = 0;
            }
            do {
                randomBit = this.function.load64(seedExpander, j);
                j = (short)(j + 8);
                bitRemained = 64;
                while (true) {
                    long z;
                    long r = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    long s3 = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    if (bitRemained <= 58) {
                        randomBit = randomBit << 6 ^ r >>> 58 & 0x3FL;
                        bitRemained = (short)(bitRemained + 6);
                    }
                    if ((r &= 0x3FFFFFFFFFFFFFFL) > 225463659665555712L) continue;
                    long y = 0L;
                    for (int i = 0; i < 12; i = (int)((short)(i + 1))) {
                        long c = s3 - CUMULATIVE_DISTRIBUTION_TABLE_I[i][1];
                        long temporary = (c & CUMULATIVE_DISTRIBUTION_TABLE_I[i][1] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_I[i][1] >> 1) + (c >>> 1) >>> 63;
                        c = r - (CUMULATIVE_DISTRIBUTION_TABLE_I[i][0] + temporary);
                        y += (c >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (bitRemained < 6) {
                            randomBit = this.function.load64(seedExpander, j);
                            j = (short)(j + 8);
                            bitRemained = 64;
                        }
                        z = randomBit & 0x3FL;
                        randomBit >>= 6;
                        bitRemained = (short)(bitRemained - 6);
                        if (z == 63L) continue;
                        if (bitRemained < 2) {
                            randomBit = this.function.load64(seedExpander, j);
                            j = (short)(j + 8);
                            bitRemained = 64;
                        }
                        z = (this.modulus7(z) << 2) + (randomBit & 3L);
                        randomBit >>= 2;
                        bitRemained = (short)(bitRemained - 2);
                        if (!((double)z >= xi)) break;
                    }
                    k = (long)(xi * (double)y + (double)z);
                    long buffer = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    if (this.bernoulli(buffer, z * ((k << 1) - z), exponentialDistribution) != 0) break;
                }
                randomBit <<= 64 - bitRemained;
                if (bitRemained == 0) {
                    randomBit = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    bitRemained = 64;
                }
                sign = randomBit >> 63;
                randomBit <<= 1;
                bitRemained = (short)(bitRemained - 1);
            } while ((k | sign & 1L) == 0L);
            if (bitRemained == 0) {
                randomBit = this.function.load64(seedExpander, j);
                j = (short)(j + 8);
                bitRemained = 64;
            }
            sign = randomBit >> 63;
            randomBit <<= 1;
            bitRemained = (short)(bitRemained - 1);
            k = (k << 1 & sign) - k;
            data[index] = k << 48 >> 48;
        }
    }

    public void polynomialGaussSamplerIII(long[] data, byte[] seed, short seedOffset, int nonce, short n, double xi, double[][] exponentialDistribution) {
        byte[] seedExpander = new byte[n * 64 / 8];
        short seedExpanderOffset = 0;
        short domainSeparator = (short)(nonce << 8);
        int j = 0;
        short s = domainSeparator;
        domainSeparator = (short)(domainSeparator + 1);
        this.fips.customizableSecureHashAlgorithmKECCAK256Simple(seedExpander, seedExpanderOffset, (short)(n * 64 / 8), s, seed, seedOffset, 32);
        for (short index = 0; index < n; index = (short)(index + 1)) {
            int bitRemained;
            long randomBit;
            long sign;
            long k;
            if (j + 46 > n) {
                short s2 = domainSeparator;
                domainSeparator = (short)(domainSeparator + 1);
                this.fips.customizableSecureHashAlgorithmKECCAK256Simple(seedExpander, seedExpanderOffset, (short)(n * 64 / 8), s2, seed, seedOffset, 32);
                j = 0;
            }
            do {
                randomBit = this.function.load64(seedExpander, j);
                j = (short)(j + 8);
                bitRemained = 64;
                while (true) {
                    long z;
                    long r = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    long s3 = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    long t = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    if (bitRemained <= 58) {
                        randomBit = randomBit << 6 ^ r >>> 58 & 0x3FL;
                        bitRemained = (short)(bitRemained + 6);
                    }
                    if ((r &= 0x3FFFFFFFFFFL) > 3440302424096L) continue;
                    long y = 0L;
                    for (int i = 0; i < 14; i = (int)((short)(i + 1))) {
                        long c = t - CUMULATIVE_DISTRIBUTION_TABLE_III[i][2];
                        long temporary = (c & CUMULATIVE_DISTRIBUTION_TABLE_III[i][2] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[i][2] >> 1) + (c >>> 1) >>> 63;
                        c = s3 - (CUMULATIVE_DISTRIBUTION_TABLE_III[i][1] + temporary);
                        temporary = (c & temporary & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[i][1] >> 1) + (c >>> 1) >>> 63;
                        c = r - (CUMULATIVE_DISTRIBUTION_TABLE_III[i][0] + temporary);
                        y += (c >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (bitRemained < 6) {
                            randomBit = this.function.load64(seedExpander, j);
                            j = (short)(j + 8);
                            bitRemained = 64;
                        }
                        z = randomBit & 0x3FL;
                        randomBit >>= 6;
                        bitRemained = (short)(bitRemained - 6);
                        if (z == 63L) continue;
                        if (bitRemained < 2) {
                            randomBit = this.function.load64(seedExpander, j);
                            j = (short)(j + 8);
                            bitRemained = 64;
                        }
                        z = (this.modulus7(z) << 2) + (randomBit & 3L);
                        randomBit >>= 2;
                        bitRemained = (short)(bitRemained - 2);
                        if (!((double)z >= xi)) break;
                    }
                    k = (long)(xi * (double)y + (double)z);
                    long buffer = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    if (this.bernoulli(buffer, z * ((k << 1) - z), exponentialDistribution) != 0) break;
                }
                randomBit <<= 64 - bitRemained;
                if (bitRemained == 0) {
                    randomBit = this.function.load64(seedExpander, j);
                    j = (short)(j + 8);
                    bitRemained = 64;
                }
                sign = randomBit >> 63;
                randomBit <<= 1;
                bitRemained = (short)(bitRemained - 1);
            } while ((k | sign & 1L) == 0L);
            if (bitRemained == 0) {
                randomBit = this.function.load64(seedExpander, j);
                j = (short)(j + 8);
                bitRemained = 64;
            }
            sign = randomBit >> 63;
            randomBit <<= 1;
            bitRemained = (short)(bitRemained - 1);
            k = (k << 1 & sign) - k;
            data[index] = k << 48 >> 48;
        }
    }

    public void encodeC(short[] positionList, short[] signList, byte[] output, short outputOffset, short n, short w) {
        short count = 0;
        short domainSeparator = 0;
        short[] C = new short[n];
        byte[] randomness = new byte[168];
        short randomnessOffset = 0;
        short s = domainSeparator;
        domainSeparator = (short)(domainSeparator + 1);
        this.fips.customizableSecureHashAlgorithmKECCAK128Simple(randomness, randomnessOffset, (short)168, s, output, outputOffset, 32);
        Arrays.fill(C, 0, (int)n, (short)0);
        short i = 0;
        while (i < w) {
            short position = (short)((short)randomness[randomnessOffset + count] << 8 | (short)randomness[randomnessOffset + count + 1]);
            position = (short)(position & n - 1);
            count = (short)(count + 2);
            if (C[position] == 0) {
                C[position] = (randomness[randomnessOffset + count] & 1) == 1 ? -1 : 1;
                positionList[i] = position;
                signList[i] = C[position];
                i = (short)(i + 1);
                count = (short)(count + 1);
            }
            if (count <= 165) continue;
            short s2 = domainSeparator;
            domainSeparator = (short)(domainSeparator + 1);
            this.fips.customizableSecureHashAlgorithmKECCAK128Simple(randomness, randomnessOffset, (short)168, s2, output, outputOffset, 32);
            count = 0;
        }
    }
}

