/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.createrepo.selectlocaldir;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import javafx.collections.ObservableSet;
import javafx.fxml.FXML;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.ls.ServerRepoManagerLs;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class CreateRepoSelectLocalDirPane
extends WizardPageContentGridPane {
    private final CreateRepoData createRepoData;
    @FXML
    private FileTreePane fileTreePane;

    public CreateRepoSelectLocalDirPane(CreateRepoData createRepoData) {
        this.createRepoData = (CreateRepoData)AssertUtil.assertNotNull((Object)createRepoData, (String)"createRepoData");
        FxmlUtil.loadDynamicComponentFxml(CreateRepoSelectLocalDirPane.class, this);
        this.fileTreePane.fileFilterProperty().set(file -> file.isDirectory());
        this.fileTreePane.getSelectedFiles().addListener(observable -> this.onSelectedFilesChanged());
        this.onSelectedFilesChanged();
    }

    protected void onSelectedFilesChanged() {
        ObservableSet<File> files = this.fileTreePane.getSelectedFiles();
        this.createRepoData.setLocalDirectory(files.isEmpty() ? null : (File)files.iterator().next());
        this.updateComplete();
    }

    @Override
    protected boolean isComplete() {
        File directory = this.createRepoData.getLocalDirectory();
        if (directory == null) {
            return false;
        }
        return ServerRepoManagerLs.getServerRepoManager().canUseLocalDirectory(directory);
    }

    public void requestFocus() {
        super.requestFocus();
        this.fileTreePane.requestFocus();
    }
}

