/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo.directory;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.user.User;
import org.subshare.gui.localrepo.directory.Messages;

public class UserListItem
extends org.subshare.gui.userlist.UserListItem {
    private final BooleanProperty owner = new SimpleBooleanProperty(this, "owner"){

        public void set(boolean newValue) {
            super.set(newValue);
            UserListItem.this.updateStrings();
        }
    };
    private final ObservableSet<PermissionType> effectivePermissionTypes = FXCollections.observableSet(new HashSet());
    private final ObservableSet<PermissionType> grantedPermissionTypes = FXCollections.observableSet(new HashSet());
    private final ObservableSet<PermissionType> inheritedPermissionTypes = FXCollections.observableSet(new HashSet());
    private final InvalidationListener updateStringsInvalidationListener = observable -> this.updateStrings();
    private final StringProperty effectivePermissionString = new SimpleStringProperty((Object)this, "effectivePermissionString");
    private final StringProperty grantedPermissionString = new SimpleStringProperty((Object)this, "grantedPermissionString");
    private final StringProperty inheritedPermissionString = new SimpleStringProperty((Object)this, "inheritedPermissionString");
    private final ObservableSet<Uid> userRepoKeyIds = FXCollections.observableSet(new HashSet());

    public UserListItem(User user) {
        super(user);
        this.effectivePermissionTypes.addListener(this.updateStringsInvalidationListener);
        this.grantedPermissionTypes.addListener(this.updateStringsInvalidationListener);
        this.inheritedPermissionTypes.addListener(this.updateStringsInvalidationListener);
    }

    private void updateStrings() {
        if (this.isOwner()) {
            String ownerPermissionString = Messages.getString("UserListItem.ownerPermissionString");
            this.setEffectivePermissionString(ownerPermissionString);
            this.setGrantedPermissionString(ownerPermissionString);
            this.setInheritedPermissionString(ownerPermissionString);
        } else {
            this.setEffectivePermissionString(UserListItem.getPermissionString(this.effectivePermissionTypes));
            this.setGrantedPermissionString(UserListItem.getPermissionString(this.grantedPermissionTypes));
            this.setInheritedPermissionString(UserListItem.getPermissionString(this.inheritedPermissionTypes));
        }
    }

    private static String getPermissionString(Set<PermissionType> permissionTypes) {
        AssertUtil.assertNotNull(permissionTypes, (String)"permissionTypes");
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<PermissionType> allPermissionTypes = new LinkedHashSet<PermissionType>(Arrays.asList(PermissionType.grant, PermissionType.write, PermissionType.read));
        allPermissionTypes.addAll(Arrays.asList(PermissionType.values()));
        for (PermissionType permissionType : allPermissionTypes) {
            if (!permissionTypes.contains(permissionType)) continue;
            if (sb.length() > 0) {
                sb.append(Messages.getString("UserListItem.permissionTypeSeparator"));
            }
            sb.append(Messages.getString(String.format("UserListItem.permissionType[%s].text", permissionType.name())));
        }
        return sb.toString();
    }

    public final boolean isOwner() {
        return this.ownerProperty().get();
    }

    public final void setOwner(boolean owner) {
        this.ownerProperty().set(owner);
    }

    public final BooleanProperty ownerProperty() {
        return this.owner;
    }

    public ObservableSet<PermissionType> getEffectivePermissionTypes() {
        return this.effectivePermissionTypes;
    }

    public ObservableSet<PermissionType> getGrantedPermissionTypes() {
        return this.grantedPermissionTypes;
    }

    public ObservableSet<PermissionType> getInheritedPermissionTypes() {
        return this.inheritedPermissionTypes;
    }

    public StringProperty effectivePermissionStringProperty() {
        return this.effectivePermissionString;
    }

    public String getEffectivePermissionString() {
        return (String)this.effectivePermissionStringProperty().get();
    }

    public void setEffectivePermissionString(String string) {
        this.effectivePermissionStringProperty().set((Object)string);
    }

    public StringProperty grantedPermissionStringProperty() {
        return this.grantedPermissionString;
    }

    public String getGrantedPermissionString() {
        return (String)this.grantedPermissionStringProperty().get();
    }

    public void setGrantedPermissionString(String string) {
        this.grantedPermissionStringProperty().set((Object)string);
    }

    public StringProperty inheritedPermissionStringProperty() {
        return this.inheritedPermissionString;
    }

    public String getInheritedPermissionString() {
        return (String)this.inheritedPermissionStringProperty().get();
    }

    public void setInheritedPermissionString(String string) {
        this.inheritedPermissionStringProperty().set((Object)string);
    }

    public ObservableSet<Uid> getUserRepoKeyIds() {
        return this.userRepoKeyIds;
    }

    public void copyFrom(UserListItem other) {
        this.setOwner(other.isOwner());
        this.effectivePermissionTypes.retainAll(other.effectivePermissionTypes);
        this.effectivePermissionTypes.addAll(other.effectivePermissionTypes);
        this.grantedPermissionTypes.retainAll(other.grantedPermissionTypes);
        this.grantedPermissionTypes.addAll(other.grantedPermissionTypes);
        this.inheritedPermissionTypes.retainAll(other.inheritedPermissionTypes);
        this.inheritedPermissionTypes.addAll(other.inheritedPermissionTypes);
        this.userRepoKeyIds.retainAll(other.userRepoKeyIds);
        this.userRepoKeyIds.addAll(other.userRepoKeyIds);
    }
}

