/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepolist;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivity;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncState;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import org.subshare.core.repo.LocalRepo;

public class LocalRepoListItem {
    private final LocalRepo localRepo;
    private RepoSyncState repoSyncState;
    private StringProperty name;
    private final StringProperty nameShown = new SimpleStringProperty((Object)this, "nameShown");
    private final ObjectProperty<Severity> severity = new SimpleObjectProperty((Object)this, "severity");
    private ObjectProperty<File> localRoot;
    private final StringProperty localRootAsString = new SimpleStringProperty((Object)this, "localRootAsString");
    private final ObjectProperty<Date> syncStarted = new SimpleObjectProperty((Object)this, "syncStarted");
    private final StringProperty syncStartedAsString = new SimpleStringProperty((Object)this, "syncStartedAsString");
    private ObjectProperty<Set<RepoSyncActivity>> repoSyncActivities = new SimpleObjectProperty((Object)this, "repoSyncActivities");

    public LocalRepoListItem(LocalRepo localRepo) {
        this.localRepo = (LocalRepo)AssertUtil.assertNotNull((Object)localRepo, (String)"localRepo");
        this.bind();
        this.updateNameShown();
    }

    private void bind() {
        try {
            this.name = JavaBeanStringPropertyBuilder.create().bean((Object)this.localRepo).name(LocalRepo.PropertyEnum.name.name()).build();
            this.localRoot = JavaBeanObjectPropertyBuilder.create().bean((Object)this.localRepo).name(LocalRepo.PropertyEnum.localRoot.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.name.addListener(observable -> this.updateNameShown());
        this.localRootAsString.bind((ObservableValue)this.localRoot.asString());
    }

    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    public ReadOnlyStringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public ReadOnlyStringProperty nameShownProperty() {
        return this.nameShown;
    }

    public String getNameShown() {
        return (String)this.nameShown.get();
    }

    public File getLocalRoot() {
        return (File)this.localRoot.get();
    }

    public ReadOnlyObjectProperty<File> localRootProperty() {
        return this.localRoot;
    }

    public String getLocalRootAsString() {
        return (String)this.localRootAsString.get();
    }

    public ReadOnlyStringProperty localRootAsStringProperty() {
        return this.localRootAsString;
    }

    public ReadOnlyObjectProperty<Severity> severityProperty() {
        return this.severity;
    }

    public Date getSyncStarted() {
        return (Date)this.syncStarted.get();
    }

    public ReadOnlyObjectProperty<Date> syncStartedProperty() {
        return this.syncStarted;
    }

    public String getSyncStartedAsString() {
        return (String)this.syncStartedAsString.get();
    }

    public ReadOnlyStringProperty syncStartedAsStringProperty() {
        return this.syncStartedAsString;
    }

    private void updateNameShown() {
        String name = this.getName();
        if (StringUtil.isEmpty((String)name)) {
            this.nameShown.set((Object)this.localRepo.getLocalRoot().getName());
        } else {
            this.nameShown.set((Object)name);
        }
    }

    private void updateSeverity() {
        RepoSyncState repoSyncState = this.getRepoSyncState();
        this.severity.set((Object)(repoSyncState == null ? null : repoSyncState.getSeverity()));
    }

    private void updateSyncStarted() {
        RepoSyncState repoSyncState = this.getRepoSyncState();
        if (repoSyncState == null) {
            this.syncStarted.set(null);
            this.syncStartedAsString.set(null);
        } else {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            this.syncStarted.set((Object)repoSyncState.getSyncStarted());
            this.syncStartedAsString.set((Object)dateFormat.format(repoSyncState.getSyncStarted()));
        }
    }

    public RepoSyncState getRepoSyncState() {
        return this.repoSyncState;
    }

    public void setRepoSyncState(RepoSyncState repoSyncState) {
        if (Util.equal((Object)this.repoSyncState, (Object)repoSyncState)) {
            return;
        }
        this.repoSyncState = repoSyncState;
        this.updateSeverity();
        this.updateSyncStarted();
    }

    public String getTooltipText() {
        return this.getRepoSyncStateTooltipText();
    }

    public ObjectProperty<Set<RepoSyncActivity>> repoSyncActivitiesProperty() {
        return this.repoSyncActivities;
    }

    public Set<RepoSyncActivity> getRepoSyncActivities() {
        return (Set)this.repoSyncActivities.get();
    }

    public void setRepoSyncActivities(Set<RepoSyncActivity> repoSyncActivities) {
        this.repoSyncActivities.set(repoSyncActivities);
    }

    private String getRepoSyncStateTooltipText() {
        RepoSyncState syncState = this.repoSyncState;
        if (syncState != null) {
            if (!StringUtil.isEmpty((String)syncState.getMessage())) {
                return syncState.getMessage();
            }
            if (syncState.getError() != null) {
                if (!StringUtil.isEmpty((String)syncState.getError().getMessage())) {
                    return syncState.getError().getClassName() + ": " + syncState.getError().getMessage();
                }
                return syncState.getError().getClassName();
            }
        }
        return null;
    }
}

