/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.user.User;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.user.EditUserManager;
import org.subshare.gui.user.UserPane;

public class UserMainTreeItem
extends MainTreeItem<User> {
    private static final Image icon = new Image(UserMainTreeItem.class.getResource("user_16x16.png").toExternalForm());
    private final EditUserManager editUserManager;

    public UserMainTreeItem(EditUserManager editUserManager, User user) {
        super(user);
        this.setGraphic((Node)new ImageView(icon));
        this.editUserManager = (EditUserManager)AssertUtil.assertNotNull((Object)editUserManager, (String)"editUserManager");
        AssertUtil.assertNotNull((Object)user, (String)"user");
    }

    @Override
    protected String getValueString() {
        User user = (User)this.getValueObject();
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)user.getFirstName())) {
            sb.append(user.getFirstName());
        }
        if (!StringUtil.isEmpty((String)user.getLastName())) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(user.getLastName());
        }
        if (!user.getEmails().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('<').append((String)user.getEmails().get(0)).append('>');
        }
        return sb.toString();
    }

    @Override
    protected Parent createMainDetailContent() {
        return new UserPane(this.editUserManager, (User)this.getValueObject());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

