/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.List;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;

public class CertificationPgpKeyTreeItem
extends PgpKeyTreeItem<PgpSignature> {
    private final PgpKeyId signaturePgpKeyId;
    private final PgpKey signaturePgpKey;

    public CertificationPgpKeyTreeItem(Pgp pgp, PgpSignature signature) {
        super(AssertUtil.assertNotNull((Object)signature, (String)"signature"));
        this.signaturePgpKeyId = (PgpKeyId)AssertUtil.assertNotNull((Object)signature.getPgpKeyId(), (String)"signature.pgpKeyId");
        AssertUtil.assertNotNull((Object)pgp, (String)"pgp");
        this.signaturePgpKey = pgp.getPgpKey(this.signaturePgpKeyId);
    }

    @Override
    public String getKeyValidity() {
        if (this.signaturePgpKey == null) {
            return null;
        }
        PgpKeyValidity kv = this.getPgp().getKeyValidity(this.signaturePgpKey);
        return kv.toShortString();
    }

    @Override
    public String getOwnerTrust() {
        if (this.signaturePgpKey == null) {
            return null;
        }
        PgpOwnerTrust ot = this.getPgp().getOwnerTrust(this.signaturePgpKey);
        return ot.toShortString();
    }

    @Override
    public String getName() {
        if (this.signaturePgpKey == null) {
            return "(unknown)";
        }
        List userIds = this.signaturePgpKey.getMasterKey().getUserIds();
        return userIds.isEmpty() ? this.getKeyId() : (String)userIds.get(0);
    }

    @Override
    public String getKeyId() {
        if (this.signaturePgpKey == null) {
            return this.signaturePgpKeyId.toHumanString();
        }
        return this.signaturePgpKey.getMasterKey().getPgpKeyId().toHumanString();
    }
}

