/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.asymmetric;

import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.subshare.crypto.AbstractCipher;
import org.subshare.crypto.CipherOperationMode;

public class AsymmetricBlockCipherImpl
extends AbstractCipher {
    private final BufferedAsymmetricBlockCipher delegate;

    public AsymmetricBlockCipherImpl(String transformation, BufferedAsymmetricBlockCipher delegate) {
        super(transformation);
        this.delegate = delegate;
    }

    @Override
    public void _init(CipherOperationMode mode, CipherParameters parameters) {
        this.delegate.init(CipherOperationMode.ENCRYPT == mode, parameters);
    }

    @Override
    public int getInputBlockSize() {
        return this.delegate.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.delegate.getOutputBlockSize();
    }

    @Override
    public void reset() {
    }

    @Override
    public int getUpdateOutputSize(int length) {
        return this.getOutputSize(length);
    }

    @Override
    public int getOutputSize(int length) {
        return this.getOutputBlockSize();
    }

    @Override
    public int update(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        this.delegate.processByte(in);
        return 0;
    }

    @Override
    public int update(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        this.delegate.processBytes(in, inOff, inLen);
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        byte[] encrypted = this.delegate.doFinal();
        System.arraycopy(encrypted, 0, out, outOff, encrypted.length);
        return encrypted.length;
    }

    @Override
    public int getIVSize() {
        return 0;
    }
}

