/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepo;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepoDao;
import co.codewizards.cloudstore.local.persistence.ModificationDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jdo.Query;

public class RemoteRepositoryDao
extends Dao<RemoteRepository, RemoteRepositoryDao> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRepository getRemoteRepository(UUID repositoryId) {
        AssertUtil.assertNotNull((Object)repositoryId, (String)"repositoryId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getRemoteRepository_repositoryId");
        try {
            RemoteRepository remoteRepository;
            RemoteRepository remoteRepository2 = remoteRepository = (RemoteRepository)query.execute((Object)repositoryId.toString());
            return remoteRepository2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRepository getRemoteRepository(URL remoteRoot) {
        AssertUtil.assertNotNull((Object)remoteRoot, (String)"remoteRoot");
        remoteRoot = UrlUtil.canonicalizeURL((URL)remoteRoot);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getRemoteRepository_remoteRootSha1");
        try {
            RemoteRepository remoteRepository;
            String remoteRootSha1 = HashUtil.sha1((String)remoteRoot.toExternalForm());
            RemoteRepository remoteRepository2 = remoteRepository = (RemoteRepository)query.execute((Object)remoteRootSha1);
            return remoteRepository2;
        }
        finally {
            query.closeAll();
        }
    }

    public RemoteRepository getRemoteRepositoryOrFail(UUID repositoryId) {
        RemoteRepository remoteRepository = this.getRemoteRepository(repositoryId);
        if (remoteRepository == null) {
            throw new IllegalArgumentException(String.format("There is no RemoteRepository with repositoryId='%s'!", repositoryId));
        }
        return remoteRepository;
    }

    public RemoteRepository getRemoteRepositoryOrFail(URL remoteRoot) {
        RemoteRepository remoteRepository = this.getRemoteRepository(remoteRoot);
        if (remoteRepository == null) {
            throw new IllegalArgumentException(String.format("There is no RemoteRepository with remoteRoot='%s'!", UrlUtil.canonicalizeURL((URL)remoteRoot)));
        }
        return remoteRepository;
    }

    public Map<UUID, URL> getRemoteRepositoryId2RemoteRootMap() {
        HashMap<UUID, URL> result = new HashMap<UUID, URL>();
        Collection remoteRepositories = this.getObjects();
        for (RemoteRepository remoteRepository : remoteRepositories) {
            if (remoteRepository.getRemoteRoot() == null) continue;
            result.put(remoteRepository.getRepositoryId(), remoteRepository.getRemoteRoot());
        }
        return result;
    }

    @Override
    public void deletePersistent(RemoteRepository entity) {
        AssertUtil.assertNotNull((Object)entity, (String)"entity");
        this.deleteDependentObjects(entity);
        this.pm().flush();
        super.deletePersistent(entity);
    }

    @Override
    public void deletePersistentAll(Collection<? extends RemoteRepository> entities) {
        AssertUtil.assertNotNull(entities, (String)"entities");
        for (RemoteRepository remoteRepository : entities) {
            this.deleteDependentObjects(remoteRepository);
        }
        this.pm().flush();
        super.deletePersistentAll(entities);
    }

    protected void deleteDependentObjects(RemoteRepository remoteRepository) {
        AssertUtil.assertNotNull((Object)remoteRepository, (String)"remoteRepository");
        ModificationDao modificationDao = this.getDao(ModificationDao.class);
        modificationDao.deletePersistentAll(modificationDao.getModifications(remoteRepository));
        LastSyncToRemoteRepoDao lastSyncToRemoteRepoDao = this.getDao(LastSyncToRemoteRepoDao.class);
        LastSyncToRemoteRepo lastSyncToRemoteRepo = lastSyncToRemoteRepoDao.getLastSyncToRemoteRepo(remoteRepository);
        if (lastSyncToRemoteRepo != null) {
            lastSyncToRemoteRepoDao.deletePersistent(lastSyncToRemoteRepo);
        }
    }
}

