/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.DeletedCollisionDto;
import org.subshare.local.persistence.DeletedCollision;
import org.subshare.local.persistence.DeletedCollisionDao;

public class DeletedCollisionDtoConverter {
    private static final Logger logger = LoggerFactory.getLogger(DeletedCollisionDtoConverter.class);
    private final LocalRepoTransaction transaction;

    public static DeletedCollisionDtoConverter create(LocalRepoTransaction transaction) {
        return (DeletedCollisionDtoConverter)ObjectFactoryUtil.createObject(DeletedCollisionDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected DeletedCollisionDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
    }

    public DeletedCollisionDto toDeletedCollisionDto(DeletedCollision deletedCollision) {
        AssertUtil.assertNotNull((Object)((Object)deletedCollision), (String)"deletedCollision");
        DeletedCollisionDto result = new DeletedCollisionDto();
        result.setCollisionId(deletedCollision.getCollisionId());
        result.setSignature(deletedCollision.getSignature());
        return result;
    }

    public DeletedCollision putDeletedCollisionDto(DeletedCollisionDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        DeletedCollisionDao dcDao = (DeletedCollisionDao)((Object)this.transaction.getDao(DeletedCollisionDao.class));
        DeletedCollision result = dcDao.getDeletedCollision(dto.getCollisionId());
        if (result == null) {
            result = new DeletedCollision(dto.getCollisionId());
        }
        result.setSignature(dto.getSignature());
        result = (DeletedCollision)dcDao.makePersistent(result);
        return result;
    }
}

