/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.ls.core.invoke.refjanitor;

import co.codewizards.cloudstore.core.collection.WeakIdentityHashMap;
import co.codewizards.cloudstore.core.ref.IdentityWeakReference;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.refjanitor.AbstractReferenceJanitor;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.listener.LocalRepoCommitEvent;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;

public class CopyOfLocalRepoCommitListenerJanitor
extends AbstractReferenceJanitor {
    private final WeakIdentityHashMap<LocalRepoCommitEventManager, List<IdentityWeakReference<LocalRepoCommitEventListener>>> manager2ListenerRefs = new WeakIdentityHashMap();
    private final WeakIdentityHashMap<LocalRepoCommitEventListener, WeakReference<FaultTolerantLocalRepoCommitListener>> originalListener2FaultTolerantLocalRepoCommitListenerRef = new WeakIdentityHashMap();

    public void preInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        MethodInvocationRequest methodInvocationRequest = extMethodInvocationRequest.getMethodInvocationRequest();
        Object bean = methodInvocationRequest.getObject();
        if (!(bean instanceof LocalRepoCommitEventManager)) {
            return;
        }
        LocalRepoCommitEventManager manager = (LocalRepoCommitEventManager)bean;
        String methodName = methodInvocationRequest.getMethodName();
        Object[] arguments = methodInvocationRequest.getArguments();
        LocalRepoCommitEventListener listener = null;
        if (arguments.length != 1 || !(arguments[0] instanceof LocalRepoCommitEventListener)) {
            return;
        }
        listener = (LocalRepoCommitEventListener)arguments[0];
        arguments[0] = this.getFaultTolerantLocalRepoCommitListenerOrCreate(listener);
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        if ("addLocalRepoCommitListener".equals(methodName)) {
            this.trackAddLocalRepoCommitListener(manager, listener);
        } else if ("removeLocalRepoCommitListener".equals(methodName)) {
            this.trackRemoveLocalRepoCommitListener(manager, listener);
        }
    }

    private synchronized FaultTolerantLocalRepoCommitListener getFaultTolerantLocalRepoCommitListenerOrCreate(LocalRepoCommitEventListener listener) {
        FaultTolerantLocalRepoCommitListener faultTolerantListener;
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        WeakReference ref = (WeakReference)this.originalListener2FaultTolerantLocalRepoCommitListenerRef.get((Object)listener);
        FaultTolerantLocalRepoCommitListener faultTolerantLocalRepoCommitListener = faultTolerantListener = ref == null ? null : (FaultTolerantLocalRepoCommitListener)ref.get();
        if (faultTolerantListener == null) {
            faultTolerantListener = new FaultTolerantLocalRepoCommitListener(listener);
            this.originalListener2FaultTolerantLocalRepoCommitListenerRef.put((Object)listener, new WeakReference<FaultTolerantLocalRepoCommitListener>(faultTolerantListener));
        }
        return faultTolerantListener;
    }

    private synchronized FaultTolerantLocalRepoCommitListener getFaultTolerantLocalRepoCommitListener(LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        WeakReference ref = (WeakReference)this.originalListener2FaultTolerantLocalRepoCommitListenerRef.get((Object)listener);
        FaultTolerantLocalRepoCommitListener faultTolerantListener = ref == null ? null : (FaultTolerantLocalRepoCommitListener)ref.get();
        return faultTolerantListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        HashMap<LocalRepoCommitEventManager, List<IdentityWeakReference<LocalRepoCommitEventListener>>> bean2ListenerRefs;
        CopyOfLocalRepoCommitListenerJanitor copyOfLocalRepoCommitListenerJanitor = this;
        synchronized (copyOfLocalRepoCommitListenerJanitor) {
            bean2ListenerRefs = new HashMap<LocalRepoCommitEventManager, List<IdentityWeakReference<LocalRepoCommitEventListener>>>((Map<LocalRepoCommitEventManager, List<IdentityWeakReference<LocalRepoCommitEventListener>>>)this.manager2ListenerRefs);
            this.manager2ListenerRefs.clear();
        }
        for (Map.Entry entry : bean2ListenerRefs.entrySet()) {
            LocalRepoCommitEventManager manager = (LocalRepoCommitEventManager)entry.getKey();
            if (manager == null) {
                throw new IllegalStateException("manager2ListenerRefs.entrySet() contained null-key!");
            }
            for (IdentityWeakReference ref : (List)entry.getValue()) {
                LocalRepoCommitEventListener listener = (LocalRepoCommitEventListener)ref.get();
                if (listener == null) continue;
                this._removeLocalRepoCommitListener(manager, listener);
            }
        }
    }

    private void _removeLocalRepoCommitListener(LocalRepoCommitEventManager manager, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        FaultTolerantLocalRepoCommitListener faultTolerantLocalRepoCommitListener = this.getFaultTolerantLocalRepoCommitListener(listener);
        if (faultTolerantLocalRepoCommitListener == null) {
            return;
        }
        manager.removeLocalRepoCommitEventListener((LocalRepoCommitEventListener)faultTolerantLocalRepoCommitListener);
    }

    private synchronized void trackAddLocalRepoCommitListener(LocalRepoCommitEventManager manager, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        LinkedList<IdentityWeakReference> listenerRefs = (LinkedList<IdentityWeakReference>)this.manager2ListenerRefs.get((Object)manager);
        if (listenerRefs == null) {
            listenerRefs = new LinkedList<IdentityWeakReference>();
            this.manager2ListenerRefs.put((Object)manager, listenerRefs);
        } else {
            this.expunge((List<IdentityWeakReference<LocalRepoCommitEventListener>>)listenerRefs);
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.add(listenerRef);
    }

    private synchronized void trackRemoveLocalRepoCommitListener(LocalRepoCommitEventManager manager, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        List listenerRefs = (List)this.manager2ListenerRefs.get((Object)manager);
        if (listenerRefs == null) {
            return;
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.remove(listenerRef);
        this.expunge(listenerRefs);
        if (listenerRefs.isEmpty()) {
            this.manager2ListenerRefs.remove((Object)manager);
        }
    }

    private void expunge(List<IdentityWeakReference<LocalRepoCommitEventListener>> listenerRefs) {
        AssertUtil.assertNotNull(listenerRefs, (String)"listenerRefs");
        Iterator<IdentityWeakReference<LocalRepoCommitEventListener>> it = listenerRefs.iterator();
        while (it.hasNext()) {
            IdentityWeakReference<LocalRepoCommitEventListener> ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }

    private static class FaultTolerantLocalRepoCommitListener
    implements LocalRepoCommitEventListener {
        private static final Logger logger = LoggerFactory.getLogger(FaultTolerantLocalRepoCommitListener.class);
        private final LocalRepoCommitEventListener delegate;

        public FaultTolerantLocalRepoCommitListener(LocalRepoCommitEventListener delegate) {
            this.delegate = (LocalRepoCommitEventListener)AssertUtil.assertNotNull((Object)delegate, (String)"delegate");
        }

        public void postCommit(LocalRepoCommitEvent event) {
            try {
                this.delegate.postCommit(event);
            }
            catch (Exception x) {
                logger.error("postCommit: " + x, (Throwable)x);
            }
        }

        protected void finalize() throws Throwable {
            logger.debug("finalize: entered.");
            super.finalize();
        }
    }
}

