/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.ls.core.invoke.refjanitor;

import co.codewizards.cloudstore.core.collection.WeakIdentityHashMap;
import co.codewizards.cloudstore.core.ref.IdentityWeakReference;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.refjanitor.AbstractReferenceJanitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.listener.LocalRepoCommitEvent;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;

public class LocalRepoCommitEventListenerJanitor
extends AbstractReferenceJanitor {
    private final WeakIdentityHashMap<LocalRepoCommitEventManager, Map<UUID, List<IdentityWeakReference<LocalRepoCommitEventListener>>>> manager2LocalRepositoryId2ListenerRefs = new WeakIdentityHashMap();
    private final WeakIdentityHashMap<LocalRepoCommitEventListener, FaultTolerantLocalRepoCommitEventListener> originalListener2FaultTolerantLocalRepoCommitEventListener = new WeakIdentityHashMap();

    public void preInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        MethodInvocationRequest methodInvocationRequest = extMethodInvocationRequest.getMethodInvocationRequest();
        Object object = methodInvocationRequest.getObject();
        if (!(object instanceof LocalRepoCommitEventManager)) {
            return;
        }
        LocalRepoCommitEventManager manager = (LocalRepoCommitEventManager)object;
        String methodName = methodInvocationRequest.getMethodName();
        Object[] arguments = methodInvocationRequest.getArguments();
        UUID localRepositoryId = null;
        LocalRepoCommitEventListener listener = null;
        if (arguments.length == 1 && arguments[0] instanceof LocalRepoCommitEventListener) {
            listener = (LocalRepoCommitEventListener)arguments[0];
            arguments[0] = this.getFaultTolerantLocalRepoCommitEventListenerOrCreate(listener);
        } else if (arguments.length == 2 && arguments[1] instanceof LocalRepoCommitEventListener) {
            listener = (LocalRepoCommitEventListener)arguments[1];
            if (!(arguments[0] instanceof UUID)) {
                return;
            }
            localRepositoryId = (UUID)arguments[0];
            arguments[1] = this.getFaultTolerantLocalRepoCommitEventListenerOrCreate(listener);
        } else {
            return;
        }
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        if ("addLocalRepoCommitEventListener".equals(methodName)) {
            this.trackAddLocalRepoCommitEventListener(manager, localRepositoryId, listener);
        } else if ("removeLocalRepoCommitEventListener".equals(methodName)) {
            this.trackRemoveLocalRepoCommitEventListener(manager, localRepositoryId, listener);
        }
    }

    private synchronized FaultTolerantLocalRepoCommitEventListener getFaultTolerantLocalRepoCommitEventListenerOrCreate(LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        FaultTolerantLocalRepoCommitEventListener faultTolerantListener = (FaultTolerantLocalRepoCommitEventListener)this.originalListener2FaultTolerantLocalRepoCommitEventListener.get((Object)listener);
        if (faultTolerantListener == null) {
            faultTolerantListener = new FaultTolerantLocalRepoCommitEventListener(listener);
            this.originalListener2FaultTolerantLocalRepoCommitEventListener.put((Object)listener, (Object)faultTolerantListener);
        }
        return faultTolerantListener;
    }

    private synchronized FaultTolerantLocalRepoCommitEventListener getFaultTolerantLocalRepoCommitEventListener(LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        FaultTolerantLocalRepoCommitEventListener faultTolerantListener = (FaultTolerantLocalRepoCommitEventListener)this.originalListener2FaultTolerantLocalRepoCommitEventListener.get((Object)listener);
        return faultTolerantListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        HashMap<LocalRepoCommitEventManager, Map<UUID, List<IdentityWeakReference<LocalRepoCommitEventListener>>>> manager2LocalRepositoryId2ListenerRefs;
        LocalRepoCommitEventListenerJanitor localRepoCommitEventListenerJanitor = this;
        synchronized (localRepoCommitEventListenerJanitor) {
            manager2LocalRepositoryId2ListenerRefs = new HashMap<LocalRepoCommitEventManager, Map<UUID, List<IdentityWeakReference<LocalRepoCommitEventListener>>>>((Map<LocalRepoCommitEventManager, Map<UUID, List<IdentityWeakReference<LocalRepoCommitEventListener>>>>)this.manager2LocalRepositoryId2ListenerRefs);
            this.manager2LocalRepositoryId2ListenerRefs.clear();
        }
        for (Map.Entry entry : manager2LocalRepositoryId2ListenerRefs.entrySet()) {
            LocalRepoCommitEventManager manager = (LocalRepoCommitEventManager)entry.getKey();
            if (manager == null) {
                throw new IllegalStateException("manager2LocalRepositoryId2ListenerRefs.entrySet() contained null-key!");
            }
            for (Map.Entry me2 : ((Map)entry.getValue()).entrySet()) {
                UUID localRepositoryId = (UUID)me2.getKey();
                for (IdentityWeakReference ref : (List)me2.getValue()) {
                    LocalRepoCommitEventListener listener = (LocalRepoCommitEventListener)ref.get();
                    if (listener == null) continue;
                    this._removeLocalRepoCommitEventListener(manager, localRepositoryId, listener);
                }
            }
        }
    }

    private void _removeLocalRepoCommitEventListener(LocalRepoCommitEventManager manager, UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        FaultTolerantLocalRepoCommitEventListener faultTolerantLocalRepoCommitEventListener = this.getFaultTolerantLocalRepoCommitEventListener(listener);
        if (faultTolerantLocalRepoCommitEventListener == null) {
            return;
        }
        manager.removeLocalRepoCommitEventListener(localRepositoryId, (LocalRepoCommitEventListener)faultTolerantLocalRepoCommitEventListener);
    }

    private synchronized void trackAddLocalRepoCommitEventListener(LocalRepoCommitEventManager manager, UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        LinkedList<IdentityWeakReference> listenerRefs;
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        HashMap localRepositoryId2ListenerRefs = (HashMap)this.manager2LocalRepositoryId2ListenerRefs.get((Object)manager);
        if (localRepositoryId2ListenerRefs == null) {
            localRepositoryId2ListenerRefs = new HashMap();
            this.manager2LocalRepositoryId2ListenerRefs.put((Object)manager, localRepositoryId2ListenerRefs);
        }
        if ((listenerRefs = (LinkedList<IdentityWeakReference>)localRepositoryId2ListenerRefs.get(localRepositoryId)) == null) {
            listenerRefs = new LinkedList<IdentityWeakReference>();
            localRepositoryId2ListenerRefs.put(localRepositoryId, listenerRefs);
        } else {
            this.expunge((List<IdentityWeakReference<LocalRepoCommitEventListener>>)listenerRefs);
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.add(listenerRef);
    }

    private synchronized void trackRemoveLocalRepoCommitEventListener(LocalRepoCommitEventManager manager, UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)manager, (String)"manager");
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        Map localRepositoryId2ListenerRefs = (Map)this.manager2LocalRepositoryId2ListenerRefs.get((Object)manager);
        if (localRepositoryId2ListenerRefs == null) {
            return;
        }
        List listenerRefs = (List)localRepositoryId2ListenerRefs.get(localRepositoryId);
        if (listenerRefs == null) {
            return;
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.remove(listenerRef);
        this.expunge(listenerRefs);
        if (listenerRefs.isEmpty()) {
            localRepositoryId2ListenerRefs.remove(localRepositoryId);
        }
        if (localRepositoryId2ListenerRefs.isEmpty()) {
            this.manager2LocalRepositoryId2ListenerRefs.remove((Object)manager);
        }
    }

    private void expunge(List<IdentityWeakReference<LocalRepoCommitEventListener>> listenerRefs) {
        AssertUtil.assertNotNull(listenerRefs, (String)"listenerRefs");
        Iterator<IdentityWeakReference<LocalRepoCommitEventListener>> it = listenerRefs.iterator();
        while (it.hasNext()) {
            IdentityWeakReference<LocalRepoCommitEventListener> ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }

    private static class FaultTolerantLocalRepoCommitEventListener
    implements LocalRepoCommitEventListener {
        private static final Logger logger = LoggerFactory.getLogger(FaultTolerantLocalRepoCommitEventListener.class);
        private final LocalRepoCommitEventListener delegate;

        public FaultTolerantLocalRepoCommitEventListener(LocalRepoCommitEventListener delegate) {
            this.delegate = (LocalRepoCommitEventListener)AssertUtil.assertNotNull((Object)delegate, (String)"delegate");
        }

        public void postCommit(LocalRepoCommitEvent event) {
            try {
                this.delegate.postCommit(event);
            }
            catch (Exception x) {
                logger.error("postCommit: " + x, (Throwable)x);
            }
        }

        protected void finalize() throws Throwable {
            logger.debug("finalize: entered.");
            super.finalize();
        }
    }
}

