/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.openpgp.wot.TrustConst;
import org.bouncycastle.openpgp.wot.internal.TrustRecordType;
import org.bouncycastle.openpgp.wot.internal.Util;

abstract class TrustRecord
implements TrustConst {
    protected long recordNum = -1L;

    TrustRecord() {
    }

    public long getRecordNum() {
        return this.recordNum;
    }

    protected void setRecordNum(long recordNum) {
        this.recordNum = recordNum;
    }

    public abstract TrustRecordType getType();

    static class Valid
    extends TrustRecord {
        protected byte[] nameHash = new byte[20];
        protected long next;
        protected short validity;
        protected short fullCount;
        protected short marginalCount;

        Valid() {
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.VALID;
        }

        public byte[] getNameHash() {
            return this.nameHash;
        }

        public void setNameHash(byte[] nameHash) {
            this.nameHash = nameHash;
        }

        public long getNext() {
            return this.next;
        }

        public void setNext(long next) {
            if (next < 0L) {
                throw new IllegalArgumentException("next < 0");
            }
            this.next = next;
        }

        public short getValidity() {
            return this.validity;
        }

        public void setValidity(short validity) {
            this.validity = validity;
        }

        public short getFullCount() {
            return this.fullCount;
        }

        public void setFullCount(short fullCount) {
            this.fullCount = fullCount;
        }

        public short getMarginalCount() {
            return this.marginalCount;
        }

        public void setMarginalCount(short marginalCount) {
            this.marginalCount = marginalCount;
        }

        public String toString() {
            return String.format("%s[recordNum=%d nameHash=%s next=%d validity=%d fullCount=%d marginalCount=%d]", this.getClass().getSimpleName(), this.recordNum, Util.encodeHexStr(this.nameHash), this.next, this.validity, this.fullCount, this.marginalCount);
        }
    }

    static class Trust
    extends TrustRecord {
        protected byte[] fingerprint = new byte[20];
        protected short ownerTrust;
        protected short depth;
        protected long validList;
        protected short minOwnerTrust;

        Trust() {
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.TRUST;
        }

        public byte[] getFingerprint() {
            return this.fingerprint;
        }

        public void setFingerprint(byte[] fingerprint) {
            this.fingerprint = fingerprint;
        }

        public short getOwnerTrust() {
            return this.ownerTrust;
        }

        public void setOwnerTrust(short ownerTrust) {
            this.ownerTrust = ownerTrust;
        }

        public short getDepth() {
            return this.depth;
        }

        public void setDepth(short depth) {
            if (depth < 0) {
                throw new IllegalArgumentException("depth < 0");
            }
            this.depth = depth;
        }

        public long getValidList() {
            return this.validList;
        }

        public void setValidList(long validList) {
            if (validList < 0L) {
                throw new IllegalArgumentException("validList < 0");
            }
            this.validList = validList;
        }

        public short getMinOwnerTrust() {
            return this.minOwnerTrust;
        }

        public void setMinOwnerTrust(short minOwnerTrust) {
            this.minOwnerTrust = minOwnerTrust;
        }

        public String toString() {
            return String.format("%s[recordNum=%d fingerprint=%s ownerTrust=%d depth=%d validList=%d minOwnerTrust=%d]", this.getClass().getSimpleName(), this.recordNum, Util.encodeHexStr(this.fingerprint), this.ownerTrust, this.depth, this.validList, this.minOwnerTrust);
        }
    }

    static class HashLst
    extends TrustRecord {
        protected long next;
        protected long[] rnum = new long[6];

        HashLst() {
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.HLST;
        }

        public long getRNum(int index) {
            return this.rnum[index];
        }

        public void setRnum(int index, long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("value < 0");
            }
            this.rnum[index] = value;
        }

        public long getNext() {
            return this.next;
        }

        public void setNext(long next) {
            if (next < 0L) {
                throw new IllegalArgumentException("next < 0");
            }
            this.next = next;
        }

        public String toString() {
            return String.format("%s[recordNum=%d next=%d rnum=%s]", this.getClass().getSimpleName(), this.recordNum, this.next, Arrays.toString(this.rnum));
        }
    }

    static class HashTbl
    extends TrustRecord {
        protected long[] item = new long[9];

        HashTbl() {
        }

        public long getItem(int index) {
            return this.item[index];
        }

        public void setItem(int index, long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("value < 0");
            }
            this.item[index] = value;
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.HTBL;
        }

        public String toString() {
            return String.format("%s[recordNum=%d item=%s]", this.getClass().getSimpleName(), this.recordNum, Arrays.toString(this.item));
        }
    }

    static class Free
    extends TrustRecord {
        protected long next;

        Free() {
        }

        public long getNext() {
            return this.next;
        }

        public void setNext(long next) {
            if (next < 0L) {
                throw new IllegalArgumentException("next < 0");
            }
            this.next = next;
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.FREE;
        }

        public String toString() {
            return String.format("%s[recordNum=%d next=%d]", this.getClass().getSimpleName(), this.recordNum, this.next);
        }
    }

    static class Version
    extends TrustRecord {
        protected short version;
        protected short marginalsNeeded;
        protected short completesNeeded;
        protected short certDepth;
        protected short trustModel;
        protected short minCertLevel;
        protected Date created;
        protected Date nextCheck;
        protected long reserved;
        protected long reserved2;
        protected long firstFree;
        protected long reserved3;
        protected long trustHashTbl;

        Version() {
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.VERSION;
        }

        public short getVersion() {
            return this.version;
        }

        public void setVersion(short version) {
            this.version = version;
        }

        public short getMarginalsNeeded() {
            return this.marginalsNeeded;
        }

        public void setMarginalsNeeded(short marginals) {
            this.marginalsNeeded = marginals;
        }

        public short getCompletesNeeded() {
            return this.completesNeeded;
        }

        public void setCompletesNeeded(short completes) {
            this.completesNeeded = completes;
        }

        public short getCertDepth() {
            return this.certDepth;
        }

        public void setCertDepth(short certDepth) {
            this.certDepth = certDepth;
        }

        public short getTrustModel() {
            return this.trustModel;
        }

        public void setTrustModel(short trustModel) {
            this.trustModel = trustModel;
        }

        public short getMinCertLevel() {
            return this.minCertLevel;
        }

        public void setMinCertLevel(short minCertLevel) {
            this.minCertLevel = minCertLevel;
        }

        public Date getCreated() {
            return this.created;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public Date getNextCheck() {
            return this.nextCheck;
        }

        public void setNextCheck(Date nextCheck) {
            this.nextCheck = nextCheck;
        }

        public long getReserved() {
            return this.reserved;
        }

        public long getReserved2() {
            return this.reserved2;
        }

        public long getFirstFree() {
            return this.firstFree;
        }

        public void setFirstFree(long firstFree) {
            this.firstFree = firstFree;
        }

        public long getReserved3() {
            return this.reserved3;
        }

        public long getTrustHashTbl() {
            return this.trustHashTbl;
        }

        public void setTrustHashTbl(long trustHashTbl) {
            this.trustHashTbl = trustHashTbl;
        }

        public String toString() {
            return String.format("%s[recordNum=%d version=%d marginalsNeeded=%d completesNeeded=%d certDepth=%d trustModel=%d minCertLevel=%d created=%s nextCheck=%s reserved=%d reserved2=%d firstFree=%d reserved3=%d trustHashTbl=%d]", this.getClass().getSimpleName(), this.recordNum, this.version, this.marginalsNeeded, this.completesNeeded, this.certDepth, this.trustModel, this.minCertLevel, this.created, this.nextCheck, this.reserved, this.reserved2, this.firstFree, this.reserved3, this.trustHashTbl);
        }
    }

    static class Unused
    extends TrustRecord {
        Unused() {
        }

        @Override
        public TrustRecordType getType() {
            return TrustRecordType.UNUSED;
        }
    }
}

