/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.subshare.core.file.EncryptedDataFile;

public class LockerEncryptedDataFile
extends EncryptedDataFile {
    private static final String MANIFEST_PROPERTY_CONTENT_VERSION = "contentVersion";
    private static final String MANIFEST_PROPERTY_REPLACED_CONTENT_VERSIONS = "replacedContentVersions";
    private static final String MANIFEST_PROPERTY_CONTENT_NAME = "contentName";

    public LockerEncryptedDataFile(byte[] in) throws IOException {
        super(in);
    }

    public LockerEncryptedDataFile(InputStream in) throws IOException {
        super(in);
    }

    public LockerEncryptedDataFile() {
    }

    public Uid getContentVersion() {
        String s = this.getManifestProperties().getProperty(MANIFEST_PROPERTY_CONTENT_VERSION);
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return new Uid(s);
    }

    public void setContentVersion(Uid contentVersion) {
        if (contentVersion == null) {
            this.getManifestProperties().remove(MANIFEST_PROPERTY_CONTENT_VERSION);
        } else {
            this.getManifestProperties().setProperty(MANIFEST_PROPERTY_CONTENT_VERSION, contentVersion.toString());
        }
    }

    public List<Uid> getReplacedContentVersions() {
        String s = this.getManifestProperties().getProperty(MANIFEST_PROPERTY_REPLACED_CONTENT_VERSIONS);
        if (StringUtil.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        ArrayList<Uid> result = new ArrayList<Uid>(3);
        for (String part : s.split(",")) {
            result.add(new Uid(part));
        }
        return Collections.unmodifiableList(result);
    }

    public void setReplacedContentVersions(Collection<Uid> replacedContentVersions) {
        if (replacedContentVersions == null || replacedContentVersions.isEmpty()) {
            this.getManifestProperties().remove(MANIFEST_PROPERTY_REPLACED_CONTENT_VERSIONS);
        } else {
            StringBuilder sb = new StringBuilder();
            for (Uid replacedContentVersion : replacedContentVersions) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(replacedContentVersion);
            }
            this.getManifestProperties().setProperty(MANIFEST_PROPERTY_REPLACED_CONTENT_VERSIONS, sb.toString());
        }
    }

    public String getContentName() {
        return this.getManifestProperties().getProperty(MANIFEST_PROPERTY_CONTENT_NAME);
    }

    public void setContentName(String contentName) {
        if (contentName == null) {
            this.getManifestProperties().remove(MANIFEST_PROPERTY_CONTENT_NAME);
        } else {
            this.getManifestProperties().setProperty(MANIFEST_PROPERTY_CONTENT_NAME, contentName);
        }
    }
}

