/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.man;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStore;

public class PgpPrivateKeyPassphraseStoreImpl
implements PgpPrivateKeyPassphraseStore {
    private final Map<PgpKeyId, char[]> pgpKeyId2Passphrase = new HashMap<PgpKeyId, char[]>();
    private final PgpAuthenticationCallback pgpAuthenticationCallback = new PgpAuthenticationCallback(){

        @Override
        public char[] getPassphrase(PgpKey pgpKey) {
            PgpKey masterKey = ((PgpKey)AssertUtil.assertNotNull((Object)pgpKey, (String)"pgpKey")).getMasterKey();
            PgpKeyId pgpKeyId = masterKey.getPgpKeyId();
            AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKey.pgpKeyId");
            return PgpPrivateKeyPassphraseStoreImpl.this.getPassphrase(pgpKeyId);
        }
    };

    private PgpPrivateKeyPassphraseStoreImpl() {
    }

    public static PgpPrivateKeyPassphraseStore getInstance() {
        return Holder.instance;
    }

    @Override
    public PgpAuthenticationCallback getPgpAuthenticationCallback() {
        return this.pgpAuthenticationCallback;
    }

    protected synchronized char[] getPassphrase(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        char[] passphrase = this.pgpKeyId2Passphrase.get(pgpKeyId);
        return passphrase;
    }

    @Override
    public synchronized boolean hasPassphrase(PgpKeyId pgpKeyId) {
        return this.pgpKeyId2Passphrase.containsKey(pgpKeyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putPassphrase(PgpKeyId pgpKeyId, char[] passphrase) throws SecurityException {
        AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        AssertUtil.assertNotNull((Object)passphrase, (String)"passphrase");
        this.assertPassphraseValid(pgpKeyId, passphrase);
        PgpPrivateKeyPassphraseStoreImpl pgpPrivateKeyPassphraseStoreImpl = this;
        synchronized (pgpPrivateKeyPassphraseStoreImpl) {
            this.pgpKeyId2Passphrase.put(pgpKeyId, passphrase);
        }
    }

    private void assertPassphraseValid(PgpKeyId pgpKeyId, char[] passphrase) throws SecurityException {
        AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        AssertUtil.assertNotNull((Object)passphrase, (String)"passphrase");
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        PgpKey pgpKey = pgp.getPgpKey(pgpKeyId);
        AssertUtil.assertNotNull((Object)pgpKey, (String)("pgp.getPgpKey(" + pgpKeyId + ")"));
        if (!pgp.testPassphrase(pgpKey, passphrase)) {
            throw new SecurityException("Wrong passphrase!");
        }
    }

    @Override
    public synchronized Set<PgpKeyId> getPgpKeyIdsHavingPassphrase() {
        return Collections.unmodifiableSet(new HashSet<PgpKeyId>(this.pgpKeyId2Passphrase.keySet()));
    }

    @Override
    public synchronized void clear() {
        this.pgpKeyId2Passphrase.clear();
    }

    private static final class Holder {
        public static final PgpPrivateKeyPassphraseStoreImpl instance = new PgpPrivateKeyPassphraseStoreImpl();

        private Holder() {
        }
    }
}

