/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repair;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairDeleteCollisionConfig {
    private static final Logger logger = LoggerFactory.getLogger(RepairDeleteCollisionConfig.class);
    public static final String CONFIG_KEY_DELETE_COLLISIONS_FROM = "repair.deleteCollisions.from";
    public static final String CONFIG_KEY_DELETE_COLLISIONS_TO = "repair.deleteCollisions.to";

    public static Date getDeleteCollisionsFrom() {
        Config config = ConfigImpl.getInstance();
        return config.getPropertyAsDate(CONFIG_KEY_DELETE_COLLISIONS_FROM, null);
    }

    public static Date getDeleteCollisionsTo() {
        Config config = ConfigImpl.getInstance();
        return config.getPropertyAsDate(CONFIG_KEY_DELETE_COLLISIONS_TO, null);
    }

    public static final boolean isCreateCollisionSuppressed() {
        Date deleteCollisionsFrom = RepairDeleteCollisionConfig.getDeleteCollisionsFrom();
        Date deleteCollisionsTo = RepairDeleteCollisionConfig.getDeleteCollisionsTo();
        if (deleteCollisionsFrom == null && deleteCollisionsTo == null) {
            return false;
        }
        if (deleteCollisionsFrom == null || deleteCollisionsTo == null) {
            logger.warn("isCreateCollisionSuppressed: Only one of the two properties '{}' and '{}' is set! To enable the collision suppression, both must be set and the current timestamp must match. Ignoring this completely and returning false!", (Object)CONFIG_KEY_DELETE_COLLISIONS_FROM, (Object)CONFIG_KEY_DELETE_COLLISIONS_TO);
            return false;
        }
        Date now = new Date();
        if (now.before(deleteCollisionsFrom)) {
            return false;
        }
        return now.before(deleteCollisionsTo);
    }

    public static Date[] getDeleteCollisionsFromInclToExclRange() {
        Date deleteCollisionsFrom = RepairDeleteCollisionConfig.getDeleteCollisionsFrom();
        Date deleteCollisionsTo = RepairDeleteCollisionConfig.getDeleteCollisionsTo();
        if (deleteCollisionsFrom == null && deleteCollisionsTo == null) {
            return null;
        }
        if (deleteCollisionsFrom == null || deleteCollisionsTo == null) {
            logger.warn("getDeleteCollisionsFromInclToExclRange: Only one of the two properties '{}' and '{}' is set! To enable the collision deletion, both must be set. Ignoring this completely and returning null!", (Object)CONFIG_KEY_DELETE_COLLISIONS_FROM, (Object)CONFIG_KEY_DELETE_COLLISIONS_TO);
            return null;
        }
        return new Date[]{deleteCollisionsFrom, deleteCollisionsTo};
    }
}

