/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.pqc.crypto.qtesla.AdvancedEncryptionStandard256CounterDeterministicRandomBitGenerator;
import org.bouncycastle.pqc.crypto.qtesla.AdvancedEncryptionStandardExtendableOutputFunction;
import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;

public class RandomNumberGenerator {
    public static final short RANDOM_NUMBER_GENERATOR_SUCCESS = 0;
    public static final short RANDOM_NUMBER_GENERATOR_BAD_MAXIMUM_LENGTH = -1;
    public static final short RANDOM_NUMBER_GENERATOR_BAD_OUTPUT_BUFFER = -2;
    public static final short RANDOM_NUMBER_GENERATOR_BAD_REQUEST_LENGTH = -3;
    private AdvancedEncryptionStandard256CounterDeterministicRandomBitGenerator drbgse = new AdvancedEncryptionStandard256CounterDeterministicRandomBitGenerator();
    private CommonFunction function = new CommonFunction();

    private void advancedEncryptionStandard256ElectronicCodeBook(byte[] key, byte[] plaintext, byte[] ciphertext, short ciphertextOffset) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKSC5Padding");
        cipher.init(1, new SecretKeySpec(key, "AES"));
        cipher.doFinal(plaintext, 0, plaintext.length, ciphertext, ciphertextOffset);
    }

    private void advancedEncryptionStandard256CounterDeterministicRandomBitGeneratorUpdate(byte[] providedData, byte[] key, byte[] value) throws BadPaddingException, InvalidKeyException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        int i;
        byte[] temporary = new byte[48];
        for (i = 0; i < 3; i = (int)((short)(i + 1))) {
            for (int j = 15; j >= 0; j = (int)((short)(j - 1))) {
                if (value[j] != 255) {
                    int n = j;
                    value[n] = (byte)(value[n] + 1);
                    break;
                }
                value[j] = 0;
            }
            this.advancedEncryptionStandard256ElectronicCodeBook(key, value, temporary, (short)(16 * i));
        }
        if (providedData != null) {
            for (i = 0; i < 48; i = (int)((short)(i + 1))) {
                int n = i;
                temporary[n] = (byte)(temporary[n] ^ providedData[i]);
            }
        }
        this.function.memoryCopy(key, 0, temporary, 0, 32);
        this.function.memoryCopy(value, 0, temporary, 32, 16);
    }

    public short initiateSeedExpander(AdvancedEncryptionStandardExtendableOutputFunction stateOfSeedExpander, byte[] seed, byte[] diversifier, long maximumLength) {
        if (maximumLength > 0xFFFFFFFFFL) {
            return -1;
        }
        stateOfSeedExpander.setRemainingLength(maximumLength);
        stateOfSeedExpander.setKey(seed, (short)0, (short)32);
        stateOfSeedExpander.setPlaintext(diversifier, (short)0, (short)8);
        stateOfSeedExpander.setPlaintextElement((short)11, (byte)(maximumLength % 256L));
        stateOfSeedExpander.setPlaintextElement((short)10, (byte)((maximumLength >>= 8) % 256L));
        stateOfSeedExpander.setPlaintextElement((short)9, (byte)((maximumLength >>= 8) % 256L));
        stateOfSeedExpander.setPlaintextElement((short)8, (byte)((maximumLength >>= 8) % 256L));
        stateOfSeedExpander.setPlaintext(12, 4, (byte)0);
        stateOfSeedExpander.setBufferPosition(16);
        stateOfSeedExpander.setBuffer(0, 16, (byte)0);
        return 0;
    }

    public short seedExpander(AdvancedEncryptionStandardExtendableOutputFunction stateOfSeedExpander, byte[] extendableOutputFunctionData, long numberOfByteToReturn) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        int offset = 0;
        if (extendableOutputFunctionData == null) {
            return -2;
        }
        if (numberOfByteToReturn >= stateOfSeedExpander.getRemainingLength()) {
            return -3;
        }
        stateOfSeedExpander.setRemainingLength(stateOfSeedExpander.getRemainingLength() - numberOfByteToReturn);
        block0: while (numberOfByteToReturn > 0L) {
            if (numberOfByteToReturn <= (long)(16 - stateOfSeedExpander.getBufferPosition())) {
                this.function.memoryCopy(extendableOutputFunctionData, offset, stateOfSeedExpander.getBuffer(), stateOfSeedExpander.getBufferPosition(), (int)numberOfByteToReturn);
                stateOfSeedExpander.setBufferPosition((int)((long)stateOfSeedExpander.getBufferPosition() + numberOfByteToReturn));
                return 0;
            }
            this.function.memoryCopy(extendableOutputFunctionData, offset, stateOfSeedExpander.getBuffer(), stateOfSeedExpander.getBufferPosition(), 16 - stateOfSeedExpander.getBufferPosition());
            numberOfByteToReturn -= (long)(16 - stateOfSeedExpander.getBufferPosition());
            offset += 16 - stateOfSeedExpander.getBufferPosition();
            this.advancedEncryptionStandard256ElectronicCodeBook(stateOfSeedExpander.getKey(), stateOfSeedExpander.getPlaintext(), stateOfSeedExpander.getBuffer(), (short)0);
            stateOfSeedExpander.setBufferPosition(0);
            for (short i = 15; i >= 12; i = (short)(i - 1)) {
                if (stateOfSeedExpander.getPlaintextElement(i) != 255) {
                    stateOfSeedExpander.setPlaintextElement(i, (byte)(stateOfSeedExpander.getPlaintextElement(i) + 1));
                    continue block0;
                }
                stateOfSeedExpander.setPlaintextElement(i, (byte)0);
            }
        }
        return 0;
    }

    public void initiateRandomByte(byte[] entropyInput, byte[] personalizationString, short securityStrength) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        byte[] seedMaterial = new byte[48];
        this.function.memoryCopy(seedMaterial, 0, entropyInput, 0, 48);
        if (personalizationString != null) {
            for (int i = 0; i < 48; i = (int)((short)(i + 1))) {
                int n = i;
                seedMaterial[n] = (byte)(seedMaterial[n] ^ personalizationString[i]);
            }
        }
        this.drbgse.setKey(0, 32, (byte)0);
        this.drbgse.setValue(0, 16, (byte)0);
        this.advancedEncryptionStandard256CounterDeterministicRandomBitGeneratorUpdate(seedMaterial, this.drbgse.getKey(), this.drbgse.getValue());
        this.drbgse.setReseedCounter((short)1);
    }

    public short randomByte(byte[] extendableOutputFunctionData, short extendableOutputFunctionDataOffset, short numberOfByteToReturn) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        byte[] block = new byte[16];
        short i = 0;
        while (numberOfByteToReturn > 0) {
            for (short j = 15; j >= 0; j = (short)(j - 1)) {
                if (this.drbgse.getValueElement(j) != 255) {
                    this.drbgse.setValueElement(j, (byte)(this.drbgse.getValueElement(j) + 1));
                    break;
                }
                this.drbgse.setValueElement(j, (byte)0);
            }
            this.advancedEncryptionStandard256ElectronicCodeBook(this.drbgse.getKey(), this.drbgse.getValue(), block, (short)0);
            if (numberOfByteToReturn > 15) {
                this.function.memoryCopy(extendableOutputFunctionData, extendableOutputFunctionDataOffset + i, block, 0, 16);
                i = (short)(i + 16);
                numberOfByteToReturn = (short)(numberOfByteToReturn - 16);
                continue;
            }
            this.function.memoryCopy(extendableOutputFunctionData, extendableOutputFunctionDataOffset + i, block, 0, (int)numberOfByteToReturn);
            numberOfByteToReturn = 0;
        }
        this.advancedEncryptionStandard256CounterDeterministicRandomBitGeneratorUpdate(null, this.drbgse.getKey(), this.drbgse.getValue());
        this.drbgse.setReseedCounter((short)(this.drbgse.getReseedCounter() + 1));
        return 0;
    }
}

