/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.DeleteModification;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.Query;

public class DeleteModificationDao
extends Dao<DeleteModification, DeleteModificationDao> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeleteModification> getDeleteModificationsForPathAfter(String path, long localRevision, RemoteRepository remoteRepository) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        AssertUtil.assertNotNull((Object)remoteRepository, (String)"remoteRepository");
        String pathSha1 = HashUtil.sha1((String)path);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getDeleteModificationsForPathAfter_pathSha1_localRevision_remoteRepository");
        try {
            Collection deleteModifications = (Collection)query.execute((Object)pathSha1, (Object)localRevision, (Object)remoteRepository);
            ArrayList<DeleteModification> arrayList = new ArrayList<DeleteModification>(deleteModifications);
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<DeleteModification> getDeleteModificationsForPathOrParentOfPathAfter(String path, long localRevision, RemoteRepository remoteRepository) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        AssertUtil.assertNotNull((Object)remoteRepository, (String)"remoteRepository");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path does not start with '/'!");
        }
        ArrayList<DeleteModification> deleteModifications = new ArrayList<DeleteModification>();
        String p = path;
        while (true) {
            Collection<DeleteModification> c = this.getDeleteModificationsForPathAfter(p, localRevision, remoteRepository);
            deleteModifications.addAll(c);
            int lastSlash = p.lastIndexOf(47);
            if (lastSlash <= 0) break;
            p = p.substring(0, lastSlash);
        }
        return deleteModifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeleteModification> getDeleteModificationsForSha1(String sha1, long length) {
        AssertUtil.assertNotNull((Object)sha1, (String)"sha1");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getDeleteModifications_sha1_length");
        try {
            Collection deleteModifications = (Collection)query.execute((Object)sha1, (Object)length);
            ArrayList<DeleteModification> arrayList = new ArrayList<DeleteModification>(deleteModifications);
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }
}

