/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.Permission;
import org.subshare.local.persistence.PermissionSetInheritance;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="PermissionSet_cryptoRepoFile", members={"cryptoRepoFile"})})
@Queries(value={@Query(name="getPermissionSet_cryptoRepoFile", value="SELECT UNIQUE WHERE this.cryptoRepoFile == :cryptoRepoFile"), @Query(name="getPermissionSetsChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision")})
@FetchGroups(value={@FetchGroup(name="PermissionSetDto", members={@Persistent(name="cryptoRepoFile"), @Persistent(name="signature")}), @FetchGroup(name="PermissionDto", members={@Persistent(name="cryptoRepoFile")}), @FetchGroup(name="PermissionSetInheritanceDto", members={@Persistent(name="cryptoRepoFile")}), @FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class PermissionSet
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoRepoFile cryptoRepoFile;
    private long localRevision;
    @Persistent(mappedBy="permissionSet")
    private Set<Permission> permissions;
    @Persistent(mappedBy="permissionSet")
    private Set<PermissionSetInheritance> permissionSetInheritances;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoRepoFile getCryptoRepoFile() {
        return PermissionSet.dnGetcryptoRepoFile(this);
    }

    public void setCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        if (!Util.equal((Object)((Object)PermissionSet.dnGetcryptoRepoFile(this)), (Object)((Object)cryptoRepoFile))) {
            PermissionSet.dnSetcryptoRepoFile(this, cryptoRepoFile);
        }
    }

    public Set<Permission> getPermissions() {
        if (PermissionSet.dnGetpermissions(this) == null) {
            PermissionSet.dnSetpermissions(this, new HashSet());
        }
        return PermissionSet.dnGetpermissions(this);
    }

    public boolean isPermissionsInherited(Date timestamp) {
        AssertUtil.assertNotNull((Object)timestamp, (String)"timestamp");
        for (PermissionSetInheritance permissionSetInheritance : this.getPermissionSetInheritances()) {
            if (permissionSetInheritance.getValidFrom().after(timestamp) || permissionSetInheritance.getValidTo() != null && permissionSetInheritance.getValidTo().compareTo(timestamp) < 0) continue;
            return true;
        }
        return false;
    }

    public Set<PermissionSetInheritance> getPermissionSetInheritances() {
        if (PermissionSet.dnGetpermissionSetInheritances(this) == null) {
            PermissionSet.dnSetpermissionSetInheritances(this, new HashSet());
        }
        return PermissionSet.dnGetpermissionSetInheritances(this);
    }

    public long getLocalRevision() {
        return PermissionSet.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)PermissionSet.dnGetlocalRevision(this), (long)localRevision)) {
            PermissionSet.dnSetlocalRevision(this, localRevision);
        }
    }

    public String getSignedDataType() {
        return "PermissionSet";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            return InputStreamSource.Helper.createInputStreamSource((Uid)PermissionSet.dnGetcryptoRepoFile(this).getCryptoRepoFileId()).createInputStream();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return PermissionSet.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)PermissionSet.dnGetsignature(this), (Object)signature)) {
            PermissionSet.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)PermissionSet.dnGetcryptoRepoFile(this)), (String)"this.cryptoRepoFile"));
        CryptoRepoFile parentCryptoRepoFile = cryptoRepoFile.getParent();
        return (Uid)AssertUtil.assertNotNull((Object)(parentCryptoRepoFile == null ? cryptoRepoFile.getCryptoRepoFileId() : parentCryptoRepoFile.getCryptoRepoFileId()), (String)"cryptoRepoFileIdControllingPermissions");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.grant;
    }

    static {
        dnFieldNames = PermissionSet.__dnFieldNamesInit();
        dnFieldTypes = PermissionSet.__dnFieldTypesInit();
        dnFieldFlags = PermissionSet.__dnFieldFlagsInit();
        dnInheritedFieldCount = PermissionSet.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = PermissionSet.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)PermissionSet.___dn$loadClass("org.subshare.local.persistence.PermissionSet"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new PermissionSet());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        PermissionSet result = new PermissionSet();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        PermissionSet result = new PermissionSet();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoRepoFile = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.permissionSetInheritances = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.permissions = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFile);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.permissionSetInheritances);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.permissions);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(PermissionSet obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoRepoFile = obj.cryptoRepoFile;
                break;
            }
            case 1: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 2: {
                this.permissionSetInheritances = obj.permissionSetInheritances;
                break;
            }
            case 3: {
                this.permissions = obj.permissions;
                break;
            }
            case 4: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof PermissionSet)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.PermissionSet");
        }
        PermissionSet other = (PermissionSet)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoRepoFile", "localRevision", "permissionSetInheritances", "permissions", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{PermissionSet.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), Long.TYPE, PermissionSet.___dn$loadClass("java.util.Set"), PermissionSet.___dn$loadClass("java.util.Set"), PermissionSet.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 21, 10, 10, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 5 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return PermissionSet.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        PermissionSet o = (PermissionSet)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoRepoFile dnGetcryptoRepoFile(PermissionSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile));
        }
        return objPC.cryptoRepoFile;
    }

    private static void dnSetcryptoRepoFile(PermissionSet objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile, (Object)val);
        }
    }

    private static long dnGetlocalRevision(PermissionSet objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(PermissionSet objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static Set dnGetpermissionSetInheritances(PermissionSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.permissionSetInheritances);
        }
        return objPC.permissionSetInheritances;
    }

    private static void dnSetpermissionSetInheritances(PermissionSet objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.permissionSetInheritances = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.permissionSetInheritances, (Object)val);
        }
    }

    private static Set dnGetpermissions(PermissionSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.permissions);
        }
        return objPC.permissions;
    }

    private static void dnSetpermissions(PermissionSet objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.permissions = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.permissions, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(PermissionSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(PermissionSet objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

