/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="UserIdentity_userIdentityId", members={"userIdentityId"})
@Index(name="UserIdentity_localRevision", members={"localRevision"})
@Queries(value={@Query(name="getUserIdentity_userIdentityId", value="SELECT UNIQUE WHERE this.userIdentityId == :userIdentityId"), @Query(name="getUserIdentitiesChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision"), @Query(name="getUserIdentities_ofUserRepoKeyPublicKey", value="SELECT WHERE this.ofUserRepoKeyPublicKey == :ofUserRepoKeyPublicKey")})
@FetchGroups(value={@FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class UserIdentity
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String userIdentityId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private UserRepoKeyPublicKey ofUserRepoKeyPublicKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] encryptedUserIdentityPayloadDtoData;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public UserIdentity() {
    }

    public UserIdentity(Uid userIdentityId) {
        this.userIdentityId = userIdentityId == null ? null : userIdentityId.toString();
    }

    public Uid getUserIdentityId() {
        if (UserIdentity.dnGetuserIdentityId(this) == null) {
            UserIdentity.dnSetuserIdentityId(this, new Uid().toString());
        }
        return new Uid(UserIdentity.dnGetuserIdentityId(this));
    }

    public UserRepoKeyPublicKey getOfUserRepoKeyPublicKey() {
        return UserIdentity.dnGetofUserRepoKeyPublicKey(this);
    }

    public void setOfUserRepoKeyPublicKey(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        if (!Util.equal((Object)((Object)UserIdentity.dnGetofUserRepoKeyPublicKey(this)), (Object)((Object)ofUserRepoKeyPublicKey))) {
            UserIdentity.dnSetofUserRepoKeyPublicKey(this, ofUserRepoKeyPublicKey);
        }
    }

    public byte[] getEncryptedUserIdentityPayloadDtoData() {
        return UserIdentity.dnGetencryptedUserIdentityPayloadDtoData(this);
    }

    public void setEncryptedUserIdentityPayloadDtoData(byte[] encryptedUserIdentityPayloadDtoData) {
        if (!Util.equal((byte[])UserIdentity.dnGetencryptedUserIdentityPayloadDtoData(this), (byte[])encryptedUserIdentityPayloadDtoData)) {
            UserIdentity.dnSetencryptedUserIdentityPayloadDtoData(this, encryptedUserIdentityPayloadDtoData);
        }
    }

    public String getSignedDataType() {
        return "UserIdentity";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getUserIdentityId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)UserIdentity.dnGetofUserRepoKeyPublicKey(this).getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((byte[])UserIdentity.dnGetencryptedUserIdentityPayloadDtoData(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return UserIdentity.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)UserIdentity.dnGetsignature(this), (Object)signature)) {
            UserIdentity.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public void jdoPreStore() {
        this.getUserIdentityId();
    }

    public long getLocalRevision() {
        return UserIdentity.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)UserIdentity.dnGetlocalRevision(this), (long)localRevision)) {
            UserIdentity.dnSetlocalRevision(this, localRevision);
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return null;
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        Signature signature = this.getSignature();
        if (signature == null || !signature.getSigningUserRepoKeyId().equals((Object)UserIdentity.dnGetofUserRepoKeyPublicKey(this).getUserRepoKeyId())) {
            return PermissionType.readUserIdentity;
        }
        return null;
    }

    static {
        dnFieldNames = UserIdentity.__dnFieldNamesInit();
        dnFieldTypes = UserIdentity.__dnFieldTypesInit();
        dnFieldFlags = UserIdentity.__dnFieldFlagsInit();
        dnInheritedFieldCount = UserIdentity.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = UserIdentity.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)UserIdentity.___dn$loadClass("org.subshare.local.persistence.UserIdentity"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new UserIdentity());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        UserIdentity result = new UserIdentity();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        UserIdentity result = new UserIdentity();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.encryptedUserIdentityPayloadDtoData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.ofUserRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 3: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.userIdentityId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.encryptedUserIdentityPayloadDtoData);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.ofUserRepoKeyPublicKey);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.userIdentityId);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(UserIdentity obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.encryptedUserIdentityPayloadDtoData = obj.encryptedUserIdentityPayloadDtoData;
                break;
            }
            case 1: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 2: {
                this.ofUserRepoKeyPublicKey = obj.ofUserRepoKeyPublicKey;
                break;
            }
            case 3: {
                this.signature = obj.signature;
                break;
            }
            case 4: {
                this.userIdentityId = obj.userIdentityId;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof UserIdentity)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.UserIdentity");
        }
        UserIdentity other = (UserIdentity)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"encryptedUserIdentityPayloadDtoData", "localRevision", "ofUserRepoKeyPublicKey", "signature", "userIdentityId"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{UserIdentity.___dn$loadClass("[B"), Long.TYPE, UserIdentity.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey"), UserIdentity.___dn$loadClass("org.subshare.local.persistence.SignatureImpl"), UserIdentity.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{26, 21, 10, 10, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 5 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return UserIdentity.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        UserIdentity o = (UserIdentity)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static byte[] dnGetencryptedUserIdentityPayloadDtoData(UserIdentity objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.encryptedUserIdentityPayloadDtoData);
        }
        return objPC.encryptedUserIdentityPayloadDtoData;
    }

    private static void dnSetencryptedUserIdentityPayloadDtoData(UserIdentity objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.encryptedUserIdentityPayloadDtoData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.encryptedUserIdentityPayloadDtoData, (Object)val);
        }
    }

    private static long dnGetlocalRevision(UserIdentity objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(UserIdentity objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static UserRepoKeyPublicKey dnGetofUserRepoKeyPublicKey(UserIdentity objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (UserRepoKeyPublicKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.ofUserRepoKeyPublicKey));
        }
        return objPC.ofUserRepoKeyPublicKey;
    }

    private static void dnSetofUserRepoKeyPublicKey(UserIdentity objPC, UserRepoKeyPublicKey val) {
        if (objPC.dnStateManager == null) {
            objPC.ofUserRepoKeyPublicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.ofUserRepoKeyPublicKey, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(UserIdentity objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(UserIdentity objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static String dnGetuserIdentityId(UserIdentity objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.userIdentityId);
        }
        return objPC.userIdentityId;
    }

    private static void dnSetuserIdentityId(UserIdentity objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.userIdentityId, val);
        } else {
            objPC.userIdentityId = val;
        }
    }
}

