/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.createrepo.selectowner;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javafx.scene.Parent;
import javafx.scene.control.SelectionMode;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.createrepo.selectowner.Messages;
import org.subshare.gui.ls.PgpPrivateKeyPassphraseManagerLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.selectuser.SelectUserPane;
import org.subshare.gui.wizard.WizardPage;

public class SelectOwnerWizardPage
extends WizardPage {
    private final CreateRepoData createRepoData;
    private SelectUserPane selectUserPane;
    private List<User> usersWithUnlockedPgpKeys;

    public SelectOwnerWizardPage(CreateRepoData createRepoData) {
        super(Messages.getString("SelectOwnerWizardPage.title"));
        this.createRepoData = (CreateRepoData)AssertUtil.assertNotNull((Object)createRepoData, (String)"createRepoData");
    }

    @Override
    protected void init() {
        super.init();
    }

    public boolean isNeeded() {
        boolean needed;
        List<User> ownerCandidates = this.getUsersWithUnlockedPgpKeys();
        boolean bl = needed = ownerCandidates.size() != 1;
        if (!needed) {
            this.createRepoData.getOwners().clear();
            this.createRepoData.getOwners().add((Object)ownerCandidates.iterator().next());
        }
        return needed;
    }

    protected synchronized List<User> getUsersWithUnlockedPgpKeys() {
        if (this.usersWithUnlockedPgpKeys == null) {
            Set pgpKeyIds = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore().getPgpKeyIdsHavingPassphrase();
            if (pgpKeyIds.isEmpty()) {
                throw new IllegalStateException("There is no PGP private key unlocked.");
            }
            UserRegistry userRegistry = UserRegistryLs.getUserRegistry();
            Collection users = userRegistry.getUsersByPgpKeyIds(pgpKeyIds);
            if (users.isEmpty()) {
                throw new IllegalStateException("There is no user for any of these PGP keys: " + pgpKeyIds);
            }
            this.usersWithUnlockedPgpKeys = new ArrayList<User>(users);
        }
        return this.usersWithUnlockedPgpKeys;
    }

    @Override
    protected Parent createContent() {
        this.selectUserPane = new SelectUserPane(this.getUsersWithUnlockedPgpKeys(), (Collection)this.createRepoData.getOwners(), SelectionMode.SINGLE, Messages.getString("SelectOwnerWizardPage.selectUserPane.headerText")){

            @Override
            protected void updateComplete() {
                SelectOwnerWizardPage.this.setComplete(!SelectOwnerWizardPage.this.createRepoData.getOwners().isEmpty());
            }
        };
        return this.selectUserPane;
    }
}

