/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.text.DateFormat;
import java.util.Date;
import org.subshare.core.pgp.PgpKey;
import org.subshare.gui.pgp.keytree.Messages;
import org.subshare.gui.pgp.keytree.PgpKeyAlgorithmName;
import org.subshare.gui.pgp.keytree.PgpKeyFlagsToUsageConverter;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;

public class SubKeyPgpKeyTreeItem
extends PgpKeyTreeItem<PgpKey> {
    public SubKeyPgpKeyTreeItem(PgpKey subKey) {
        super(AssertUtil.assertNotNull((Object)subKey, (String)"subKey"));
    }

    @Override
    public String getName() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        if (subKey.getMasterKey() == subKey) {
            return Messages.getString("SubKeyPgpKeyTreeItem.name[masterKey]");
        }
        return Messages.getString("SubKeyPgpKeyTreeItem.name[subKey]");
    }

    @Override
    public String getKeyId() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        return subKey.getPgpKeyId().toHumanString();
    }

    @Override
    public String getCreated() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        Date created = subKey.getCreated();
        if (created == null) {
            return null;
        }
        return DateFormat.getDateInstance(3).format(created);
    }

    @Override
    public String getValidTo() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        Date validTo = subKey.getValidTo();
        if (validTo == null) {
            return null;
        }
        return DateFormat.getDateInstance(3).format(validTo);
    }

    @Override
    public String getAlgorithm() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        return PgpKeyAlgorithmName.getPgpKeyAlgorithmName(subKey.getAlgorithm());
    }

    @Override
    public String getStrength() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        return Integer.toString(subKey.getStrength());
    }

    @Override
    public String getUsage() {
        PgpKey subKey = (PgpKey)this.getValueObject();
        return new PgpKeyFlagsToUsageConverter().toUsage(subKey.getPgpKeyFlags());
    }
}

