/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.serverlist;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import org.subshare.core.server.Server;
import org.subshare.core.sync.SyncState;

public class ServerListItem {
    private final Server server;
    private SyncState pgpSyncState;
    private SyncState lockerSyncState;
    private final StringProperty name;
    private final ObjectProperty<URL> url;
    private final ObjectProperty<Severity> severity = new SimpleObjectProperty((Object)this, "severity");

    public ServerListItem(Server server) {
        this.server = (Server)AssertUtil.assertNotNull((Object)server, (String)"server");
        try {
            this.name = JavaBeanStringPropertyBuilder.create().bean((Object)server).name(Server.PropertyEnum.name.name()).build();
            this.url = JavaBeanObjectPropertyBuilder.create().bean((Object)server).name(Server.PropertyEnum.url.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.updateSeverity();
    }

    public Server getServer() {
        return this.server;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public ObjectProperty<URL> urlProperty() {
        return this.url;
    }

    public ObjectProperty<Severity> severityProperty() {
        return this.severity;
    }

    private void updateSeverity() {
        SyncState pgpSyncState = this.getPgpSyncState();
        SyncState lockerSyncState = this.getLockerSyncState();
        this.severity.set((Object)ServerListItem.getHighestSeverity(pgpSyncState == null ? null : pgpSyncState.getSeverity(), lockerSyncState == null ? null : lockerSyncState.getSeverity()));
    }

    private static Severity getHighestSeverity(Severity ... severities) {
        Severity result = Severity.values()[0];
        for (Severity severity : severities) {
            if (severity == null || result.ordinal() >= severity.ordinal()) continue;
            result = severity;
        }
        return result;
    }

    public SyncState getPgpSyncState() {
        return this.pgpSyncState;
    }

    public void setPgpSyncState(SyncState pgpSyncState) {
        this.pgpSyncState = pgpSyncState;
        this.updateSeverity();
    }

    public SyncState getLockerSyncState() {
        return this.lockerSyncState;
    }

    public void setLockerSyncState(SyncState lockerSyncState) {
        this.lockerSyncState = lockerSyncState;
        this.updateSeverity();
    }

    public String getTooltipText() {
        return this.assembleTooltipText(this.getPgpSyncStateTooltipText(), this.getLockerSyncStateTooltipText());
    }

    private String assembleTooltipText(String ... tooltipTexts) {
        AssertUtil.assertNotNull((Object)tooltipTexts, (String)"tooltipTexts");
        List<String> tooltipTextList = Arrays.asList(tooltipTexts);
        return this.assembleTooltipText(tooltipTextList);
    }

    private String assembleTooltipText(List<String> tooltipTexts) {
        if ((tooltipTexts = this.filterEmpty(tooltipTexts)).isEmpty()) {
            return null;
        }
        if (tooltipTexts.size() == 1) {
            return tooltipTexts.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String tooltipText : tooltipTexts) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("* ").append(tooltipText);
        }
        return sb.toString();
    }

    private List<String> filterEmpty(List<String> strings) {
        AssertUtil.assertNotNull(strings, (String)"strings");
        ArrayList<String> result = new ArrayList<String>(strings.size());
        for (String string : strings) {
            if (StringUtil.isEmpty((String)string)) continue;
            result.add(string);
        }
        return result;
    }

    private String getPgpSyncStateTooltipText() {
        return ServerListItem.getSyncStateTooltipText(this.pgpSyncState);
    }

    private String getLockerSyncStateTooltipText() {
        return ServerListItem.getSyncStateTooltipText(this.lockerSyncState);
    }

    private static String getSyncStateTooltipText(SyncState syncState) {
        if (syncState != null) {
            if (!StringUtil.isEmpty((String)syncState.getMessage())) {
                return syncState.getMessage();
            }
            if (syncState.getError() != null) {
                if (!StringUtil.isEmpty((String)syncState.getError().getMessage())) {
                    return syncState.getError().getClassName() + ": " + syncState.getError().getMessage();
                }
                return syncState.getError().getClassName();
            }
        }
        return null;
    }
}

