/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.io;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockFileImpl
implements LockFile {
    private static final Logger logger = LoggerFactory.getLogger(LockFileImpl.class);
    private final LockFileFactory lockFileFactory;
    private final File file;
    private final String thisID = Integer.toHexString(System.identityHashCode(this));
    protected int acquireRunningCounter = 0;
    private int lockCounter = 0;
    private RandomAccessFile randomAccessFile;
    private FileLock fileLock;
    private final Lock lock = new ReentrantLock();
    private final Object mutex = this;

    protected LockFileImpl(LockFileFactory lockFileFactory, File file) {
        this.lockFileFactory = AssertUtil.assertNotNull(lockFileFactory, "lockFileFactory");
        this.file = AssertUtil.assertNotNull(file, "file");
        logger.debug("[{}]<init>: file='{}'", (Object)this.thisID, (Object)file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    private boolean tryAcquire() {
        logger.trace("[{}]tryAcquire: entered. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("[{}]tryAcquire: inside synchronized", (Object)this.thisID);
            try {
                if (this.randomAccessFile == null) {
                    logger.trace("[{}]tryAcquire: acquiring underlying FileLock for file={}.", (Object)this.thisID, (Object)Integer.toHexString(System.identityHashCode(this.file)));
                    this.randomAccessFile = this.file.createRandomAccessFile("rw");
                    try {
                        this.fileLock = this.randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, false);
                    }
                    catch (OverlappingFileLockException x) {
                        Util.doNothing();
                    }
                    finally {
                        if (this.fileLock == null) {
                            logger.trace("[{}]tryAcquire: fileLock was NOT acquired. Closing randomAccessFile now.", (Object)this.thisID);
                            this.randomAccessFile.close();
                            this.randomAccessFile = null;
                        }
                    }
                    if (this.fileLock == null) {
                        logger.debug("[{}]tryAcquire: returning false. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
                        return false;
                    }
                }
                ++this.lockCounter;
                logger.debug("[{}]tryAcquire: returning true. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
                return true;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public void acquire(long timeoutMillis) throws TimeoutException {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timeoutMillis < 0");
        }
        long beginTimestamp = System.currentTimeMillis();
        while (!this.tryAcquire()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Util.doNothing();
            }
            if (timeoutMillis <= 0L || System.currentTimeMillis() - beginTimestamp <= timeoutMillis) continue;
            throw new TimeoutException(String.format("Could not lock '%s' within timeout of %s ms!", this.file.getAbsolutePath(), timeoutMillis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        logger.trace("[{}]release: entered. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("[{}]release: inside synchronized", (Object)this.thisID);
            int lockCounterValue = --this.lockCounter;
            if (lockCounterValue > 0) {
                logger.debug("[{}]release: NOT releasing underlying FileLock. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
                return;
            }
            if (lockCounterValue < 0) {
                throw new IllegalStateException("Trying to release more often than was acquired!!!");
            }
            logger.debug("[{}]release: releasing underlying FileLock. lockCounter={}", (Object)this.thisID, (Object)this.lockCounter);
            try {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                }
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        this.lockFileFactory.postRelease(this);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Only the LockFileProxy should be used! This method should therefore never be invoked!");
    }

    protected int getLockCounter() {
        return this.lockCounter;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public IInputStream createInputStream() throws IOException {
        return new LockFileInputStream();
    }

    @Override
    public IOutputStream createOutputStream() throws IOException {
        return new LockFileOutputStream();
    }

    private class LockFileOutputStream
    extends OutputStream
    implements IOutputStream {
        private long position;

        public LockFileOutputStream() throws IOException {
            LockFileImpl.this.lock.lock();
            LockFileImpl.this.randomAccessFile.setLength(0L);
        }

        @Override
        public void write(int b) throws IOException {
            LockFileImpl.this.randomAccessFile.seek(this.position);
            LockFileImpl.this.randomAccessFile.write(b);
            this.position = LockFileImpl.this.randomAccessFile.getFilePointer();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LockFileImpl.this.randomAccessFile.seek(this.position);
            LockFileImpl.this.randomAccessFile.write(b, off, len);
            this.position = LockFileImpl.this.randomAccessFile.getFilePointer();
        }

        @Override
        public void close() throws IOException {
            super.close();
            LockFileImpl.this.lock.unlock();
        }
    }

    private class LockFileInputStream
    extends InputStream
    implements IInputStream {
        private long position;

        public LockFileInputStream() {
            LockFileImpl.this.lock.lock();
        }

        @Override
        public int read() throws IOException {
            LockFileImpl.this.randomAccessFile.seek(this.position);
            int result = LockFileImpl.this.randomAccessFile.read();
            this.position = LockFileImpl.this.randomAccessFile.getFilePointer();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            LockFileImpl.this.randomAccessFile.seek(this.position);
            int result = LockFileImpl.this.randomAccessFile.read(b, off, len);
            this.position = LockFileImpl.this.randomAccessFile.getFilePointer();
            return result;
        }

        @Override
        public void close() throws IOException {
            super.close();
            LockFileImpl.this.lock.unlock();
        }
    }
}

