/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivityType;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.Serializable;
import java.util.UUID;

public class RepoSyncActivity
implements Serializable {
    private final UUID localRepositoryId;
    private final File localRoot;
    private final RepoSyncActivityType activityType;

    public RepoSyncActivity(UUID localRepositoryId, File localRoot, RepoSyncActivityType activityType) {
        this.localRepositoryId = AssertUtil.assertNotNull(localRepositoryId, "localRepositoryId");
        this.localRoot = AssertUtil.assertNotNull(localRoot, "localRoot");
        this.activityType = AssertUtil.assertNotNull(activityType, "activityType");
    }

    public UUID getLocalRepositoryId() {
        return this.localRepositoryId;
    }

    public File getLocalRoot() {
        return this.localRoot;
    }

    public RepoSyncActivityType getActivityType() {
        return this.activityType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localRepositoryId == null ? 0 : this.localRepositoryId.hashCode());
        result = 31 * result + (this.activityType == null ? 0 : this.activityType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepoSyncActivity other = (RepoSyncActivity)obj;
        return Util.equal(this.localRepositoryId, other.localRepositoryId) && Util.equal(this.activityType, other.activityType);
    }

    public String toString() {
        return String.format("%s[localRepositoryId=%s, localRoot='%s', activityType=%s]", new Object[]{this.getClass().getName(), this.localRepositoryId, this.localRoot, this.activityType});
    }
}

