/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.progress;

import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.ProgressMonitorDelegator;

public class SubProgressMonitor
extends ProgressMonitorDelegator {
    public static final int SUPPRESS_SUBTASK_LABEL = 2;
    public static final int PREPEND_MAIN_LABEL_TO_SUBTASK = 4;
    private int parentTicks = 0;
    private double sentToParent = 0.0;
    private double scale = 0.0;
    private int nestedBeginTasks = 0;
    private boolean usedUp = false;
    private boolean hasSubTask = false;
    private int style;
    private String mainTaskLabel;

    public SubProgressMonitor(ProgressMonitor wrappedMonitor, int ticks) {
        this(wrappedMonitor, ticks, 0);
    }

    public SubProgressMonitor(ProgressMonitor wrappedMonitor, int ticks, int style) {
        super(wrappedMonitor);
        this.parentTicks = ticks;
        this.style = style;
    }

    @Override
    public synchronized void beginTask(String name, int totalWork) {
        ++this.nestedBeginTasks;
        if (this.nestedBeginTasks > 1) {
            return;
        }
        double d = this.scale = totalWork <= 0 ? 0.0 : (double)this.parentTicks / (double)totalWork;
        if ((this.style & 4) != 0) {
            this.mainTaskLabel = name;
        }
    }

    @Override
    public synchronized void done() {
        if (this.nestedBeginTasks == 0 || --this.nestedBeginTasks > 0) {
            return;
        }
        double remaining = (double)this.parentTicks - this.sentToParent;
        if (remaining > 0.0) {
            super.internalWorked(remaining);
        }
        if (this.hasSubTask) {
            this.subTask("");
        }
        this.sentToParent = 0.0;
    }

    @Override
    public synchronized void internalWorked(double work) {
        if (this.usedUp || this.nestedBeginTasks != 1) {
            return;
        }
        double realWork = this.scale * work;
        super.internalWorked(realWork);
        this.sentToParent += realWork;
        if (this.sentToParent >= (double)this.parentTicks) {
            this.usedUp = true;
        }
    }

    @Override
    public synchronized void subTask(String name) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.hasSubTask = true;
        String label = name;
        if ((this.style & 4) != 0 && this.mainTaskLabel != null && this.mainTaskLabel.length() > 0) {
            label = this.mainTaskLabel + ' ' + label;
        }
        super.subTask(label);
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }
}

