/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;

public class FileNoDirectoryException
extends LocalRepoManagerException {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileNoDirectoryException(File file) {
        super(FileNoDirectoryException.createMessage(file));
        this.file = file;
    }

    public FileNoDirectoryException(File file, Throwable cause) {
        super(FileNoDirectoryException.createMessage(file), cause);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String createMessage(File file) {
        return String.format("File exists, but is not a directory: %s", file == null ? null : file.getAbsolutePath());
    }
}

