/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;

public class FileNoRepositoryException
extends LocalRepoManagerException {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileNoRepositoryException(File file) {
        super(FileNoRepositoryException.createMessage(file));
        this.file = file;
    }

    public FileNoRepositoryException(File file, Throwable cause) {
        super(FileNoRepositoryException.createMessage(file), cause);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String createMessage(File file) {
        return String.format("File is an existing directory, but it is not a repository: %s", file == null ? null : file.getAbsolutePath());
    }
}

