/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.LinkedHashSet;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;

public class FetchPlanBackup {
    private LinkedHashSet<String> groups;
    private int fetchSize;
    private int maxFetchDepth;

    protected FetchPlanBackup() {
    }

    public static FetchPlanBackup createFrom(PersistenceManager pm) {
        return FetchPlanBackup.createFrom(((PersistenceManager)AssertUtil.assertNotNull((Object)pm, (String)"pm")).getFetchPlan());
    }

    public static FetchPlanBackup createFrom(FetchPlan fetchPlan) {
        AssertUtil.assertNotNull((Object)fetchPlan, (String)"fetchPlan");
        FetchPlanBackup fetchPlanBackup = (FetchPlanBackup)ObjectFactoryUtil.createObject(FetchPlanBackup.class);
        fetchPlanBackup.init(fetchPlan);
        return fetchPlanBackup;
    }

    public void init(FetchPlan fetchPlan) {
        AssertUtil.assertNotNull((Object)fetchPlan, (String)"fetchPlan");
        this.groups = new LinkedHashSet(fetchPlan.getGroups());
        this.fetchSize = fetchPlan.getFetchSize();
        this.maxFetchDepth = fetchPlan.getMaxFetchDepth();
    }

    public void restore(PersistenceManager pm) {
        this.restore(((PersistenceManager)AssertUtil.assertNotNull((Object)pm, (String)"pm")).getFetchPlan());
    }

    public void restore(FetchPlan fetchPlan) {
        AssertUtil.assertNotNull((Object)fetchPlan, (String)"fetchPlan");
        if (this.groups == null) {
            throw new IllegalStateException("init(...) was not called!");
        }
        fetchPlan.setGroups(this.groups);
        fetchPlan.setFetchSize(this.fetchSize);
        fetchPlan.setMaxFetchDepth(this.maxFetchDepth);
    }
}

