/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRepoInvitationToken;

public interface UserRepoInvitationManager {
    public int getPriority();

    public UserRegistry getUserRegistry();

    public void setUserRegistry(UserRegistry var1);

    public LocalRepoManager getLocalRepoManager();

    public void setLocalRepoManager(LocalRepoManager var1);

    public UserRepoInvitationToken createUserRepoInvitationToken(String var1, User var2, Set<PgpKey> var3, PermissionType var4, long var5);

    public ServerRepo importUserRepoInvitationToken(UserRepoInvitationToken var1);

    public static class Helper {
        public static UserRepoInvitationManager getInstance(UserRegistry userRegistry, LocalRepoManager localRepoManager) {
            AssertUtil.assertNotNull((Object)userRegistry, (String)"userRegistry");
            AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
            ServiceLoader<UserRepoInvitationManager> serviceLoader = ServiceLoader.load(UserRepoInvitationManager.class);
            Iterator<UserRepoInvitationManager> iterator = serviceLoader.iterator();
            UserRepoInvitationManager result = null;
            while (iterator.hasNext()) {
                UserRepoInvitationManager manager = iterator.next();
                if (result != null && result.getPriority() >= manager.getPriority()) continue;
                result = manager;
            }
            if (result == null) {
                throw new IllegalStateException("No UserRepoInvitationManager implementation found!");
            }
            result.setUserRegistry(userRegistry);
            result.setLocalRepoManager(localRepoManager);
            return result;
        }
    }
}

