/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.util.Util;
import java.util.ArrayList;
import java.util.Locale;

public final class MainArgsUtil {
    private MainArgsUtil() {
    }

    public static String[][] separateSystemPropertiesFromOtherArgs(String[] args) {
        ArrayList<String> sysPropArgs = new ArrayList<String>(args.length);
        ArrayList<String> otherArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                sysPropArgs.add(arg);
                continue;
            }
            otherArgs.add(arg);
        }
        return new String[][]{sysPropArgs.toArray(new String[sysPropArgs.size()]), otherArgs.toArray(new String[otherArgs.size()])};
    }

    public static String[] extractAndApplySystemPropertiesReturnOthers(String[] args) {
        String[][] sysPropArgsAndOtherArgs = MainArgsUtil.separateSystemPropertiesFromOtherArgs(args);
        String[] sysPropArgs = sysPropArgsAndOtherArgs[0];
        String[] otherArgs = sysPropArgsAndOtherArgs[1];
        for (String arg : sysPropArgs) {
            if (!arg.startsWith("-D")) {
                throw new IllegalStateException("sysPropArgs contains element not starting with '-D': " + arg);
            }
            String kv = arg.substring(2);
            int equalsIndex = kv.indexOf(61);
            if (equalsIndex >= 0) {
                String k = kv.substring(0, equalsIndex);
                String v = kv.substring(equalsIndex + 1);
                System.setProperty(k, v);
                continue;
            }
            System.setProperty(kv, "");
        }
        MainArgsUtil.applyLocaleIfNeeded();
        return otherArgs;
    }

    private static void applyLocaleIfNeeded() {
        String userLanguage = System.getProperty("user.language");
        String userCountry = System.getProperty("user.country");
        Locale locale = Locale.getDefault();
        if (!Util.equal(userLanguage, locale.getLanguage()) || !Util.equal(userCountry, locale.getCountry())) {
            Locale.setDefault(new Locale(userLanguage, userCountry));
        }
    }
}

