/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.client.transport;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.ModificationDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDtoTreeNode;
import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseAdapter;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseListener;
import co.codewizards.cloudstore.core.repo.transport.AbstractRepoTransport;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.ExceptionUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.rest.client.CloudStoreRestClient;
import co.codewizards.cloudstore.rest.client.request.Request;
import co.codewizards.cloudstore.rest.client.request.RequestRepoConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.AccessDeniedException;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.DataKey;
import org.subshare.core.FileDeletedException;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactoryRegistry;
import org.subshare.core.WriteAccessDeniedException;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.core.crypto.DecrypterInputStream;
import org.subshare.core.crypto.EncrypterOutputStream;
import org.subshare.core.crypto.IvFactory;
import org.subshare.core.crypto.RandomIvFactory;
import org.subshare.core.dto.CreateRepositoryRequestDto;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.RepoFileDtoWithCurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.SsDeleteModificationDto;
import org.subshare.core.dto.SsDirectoryDto;
import org.subshare.core.dto.SsNormalFileDto;
import org.subshare.core.dto.SsRepoFileDto;
import org.subshare.core.dto.SsRequestRepoConnectionRepositoryDto;
import org.subshare.core.dto.SsSymlinkDto;
import org.subshare.core.dto.split.CryptoChangeSetDtoSplitFileManager;
import org.subshare.core.dto.split.CryptoChangeSetDtoTooLargeException;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.repo.transport.CryptreeRestRepoTransport;
import org.subshare.core.sign.PgpSignable;
import org.subshare.core.sign.PgpSignableSigner;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.SignableSigner;
import org.subshare.core.sign.SignableVerifier;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.SignerOutputStream;
import org.subshare.core.sign.VerifierInputStream;
import org.subshare.core.sign.WriteProtected;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;
import org.subshare.rest.client.transport.CryptreeRestRepoTransportFactoryImpl;
import org.subshare.rest.client.transport.RestRepoTransport;
import org.subshare.rest.client.transport.RestRepoTransportFactory;
import org.subshare.rest.client.transport.request.CreateRepository;
import org.subshare.rest.client.transport.request.EndGetCryptoChangeSetDto;
import org.subshare.rest.client.transport.request.GetCryptoChangeSetDto;
import org.subshare.rest.client.transport.request.GetCryptoChangeSetDtoFileData;
import org.subshare.rest.client.transport.request.GetHistoFileData;
import org.subshare.rest.client.transport.request.GetLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced;
import org.subshare.rest.client.transport.request.PutCryptoChangeSetDto;
import org.subshare.rest.client.transport.request.SsBeginPutFile;
import org.subshare.rest.client.transport.request.SsDelete;
import org.subshare.rest.client.transport.request.SsEndPutFile;
import org.subshare.rest.client.transport.request.SsMakeDirectory;
import org.subshare.rest.client.transport.request.SsMakeSymlink;

public class CryptreeRestRepoTransportImpl
extends AbstractRepoTransport
implements CryptreeRestRepoTransport,
ContextWithLocalRepoManager {
    private static final Logger logger = LoggerFactory.getLogger(CryptreeRestRepoTransportImpl.class);
    public static final String CONFIG_KEY_GET_CRYPTO_CHANGE_SET_DTO_TIMEOUT = "getCryptoChangeSetDtoTimeout";
    public static final long CONFIG_DEFAULT_VALUE_GET_CRYPTO_CHANGE_SET_DTO_TIMEOUT = 0x6DDD00L;
    private final long cryptoChangeSetTimeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroLong("getCryptoChangeSetDtoTimeout", 0x6DDD00L);
    private CryptreeFactory cryptreeFactory;
    private RestRepoTransport restRepoTransport;
    private LocalRepoManager localRepoManager;
    private UserRepoKeyRing userRepoKeyRing;

    public RepositoryDto getRepositoryDto() {
        return this.getRestRepoTransport().getRepositoryDto();
    }

    public RepositoryDto getClientRepositoryDto() {
        return this.getRestRepoTransport().getClientRepositoryDto();
    }

    public UUID getRepositoryId() {
        return this.getRestRepoTransport().getRepositoryId();
    }

    public byte[] getPublicKey() {
        return this.getRestRepoTransport().getPublicKey();
    }

    public void createRepository(UUID serverRepositoryId, PgpKey pgpKey) {
        AssertUtil.assertNotNull((Object)pgpKey, (String)"pgpKey");
        CreateRepositoryRequestDto createRepositoryRequestDto = new CreateRepositoryRequestDto();
        createRepositoryRequestDto.setServerRepositoryId(serverRepositoryId);
        new PgpSignableSigner(pgpKey).sign((PgpSignable)createRepositoryRequestDto);
        this.getClient().execute((Request)new CreateRepository(createRepositoryRequestDto));
    }

    public void requestRepoConnection(byte[] publicKey) {
        UserRepoKey signingUserRepoKey;
        UUID serverRepositoryId = this.getRepositoryId();
        String repositoryName = this.getRestRepoTransport().getRepositoryName();
        SsRequestRepoConnectionRepositoryDto repositoryDto = new SsRequestRepoConnectionRepositoryDto();
        repositoryDto.setRepositoryId(this.getClientRepositoryIdOrFail());
        repositoryDto.setPublicKey(publicKey);
        List invitationUserRepoKeys = this.getUserRepoKeyRing().getInvitationUserRepoKeys(serverRepositoryId);
        UserRepoKey userRepoKey = signingUserRepoKey = invitationUserRepoKeys.isEmpty() ? null : (UserRepoKey)invitationUserRepoKeys.get(0);
        if (signingUserRepoKey == null) {
            List permanentUserRepoKeys = this.getUserRepoKeyRing().getPermanentUserRepoKeys(serverRepositoryId);
            if (permanentUserRepoKeys.isEmpty()) {
                throw new IllegalStateException("There is no UserRepoKey for serverRepositoryId=" + serverRepositoryId);
            }
            signingUserRepoKey = (UserRepoKey)permanentUserRepoKeys.get(0);
        }
        new SignableSigner(signingUserRepoKey).sign((Signable)repositoryDto);
        this.getClient().execute((Request)new RequestRepoConnection(repositoryName, this.getPathPrefix(), (RepositoryDto)repositoryDto));
    }

    public ChangeSetDto getChangeSetDto(boolean localSync, Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced) {
        ChangeSetDto changeSetDto = this.getRestRepoTransport().getChangeSetDto(localSync, lastSyncToRemoteRepoLocalRepositoryRevisionSynced);
        if (logger.isInfoEnabled()) {
            logger.info("getChangeSetDto: clientRepositoryId={} serverRepositoryId={}: repoFileDtos.size={}", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), changeSetDto.getRepoFileDtos().size()});
            DebugUtil.logMemoryStats((Logger)logger);
            logger.trace("getChangeSetDto: {}", (Object)changeSetDto);
        }
        this.syncCryptoKeysFromRemoteRepo();
        return this.decryptChangeSetDto(changeSetDto);
    }

    public void prepareForChangeSetDto(ChangeSetDto changeSetDto) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptoChangeSetDto = cryptree.createHistoCryptoRepoFilesForDeletedCryptoRepoFiles();
            transaction.commit();
        }
        if (cryptoChangeSetDto != null) {
            transaction = localRepoManager.beginWriteTransaction();
            var5_4 = null;
            try {
                cryptree = this.getCryptree(transaction);
                this.putCryptoChangeSetDto(cryptoChangeSetDto);
                cryptree.updateLastCryptoKeySyncToRemoteRepo();
                transaction.commit();
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var5_4 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
    }

    protected String determinePathPrefix() {
        String pathPrefix = super.determinePathPrefix();
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptreeFactory().getCryptreeOrCreate(transaction, this.getRepositoryId(), pathPrefix, this.getUserRepoKeyRing());
            cryptree.registerRemotePathPrefix(pathPrefix);
            transaction.commit();
        }
        return pathPrefix;
    }

    private void syncCryptoKeysFromRemoteRepo() {
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced = null;
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced = cryptree.getLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced();
        }
        CryptoChangeSetDtoTooLargeException cryptoChangeSetDtoTooLargeException = null;
        CryptoChangeSetDto cryptoChangeSetDto = null;
        long beginTimestamp = System.currentTimeMillis();
        while (true) {
            try {
                cryptoChangeSetDto = (CryptoChangeSetDto)this.getClient().execute((Request)new GetCryptoChangeSetDto(this.getRepositoryId().toString(), lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced));
            }
            catch (DeferredCompletionException x) {
                if (System.currentTimeMillis() > beginTimestamp + this.cryptoChangeSetTimeout) {
                    throw new TimeoutException(String.format("Could not get crypto-change-set within %s milliseconds!", this.cryptoChangeSetTimeout), (Throwable)x);
                }
                logger.info("syncCryptoKeysFromRemoteRepo: Got DeferredCompletionException; will retry.");
                continue;
            }
            catch (Exception x) {
                cryptoChangeSetDtoTooLargeException = (CryptoChangeSetDtoTooLargeException)ExceptionUtil.getCause((Throwable)x, CryptoChangeSetDtoTooLargeException.class);
                if (cryptoChangeSetDtoTooLargeException != null) break;
                throw x;
            }
            break;
        }
        if (cryptoChangeSetDto != null) {
            this.syncCryptoKeysFromRemoteRepo_putCryptoChangeSetDto(cryptoChangeSetDto);
        } else {
            if (cryptoChangeSetDtoTooLargeException == null) {
                throw new IllegalStateException("cryptoChangeSetDto and cryptoChangeSetTooLargeException are both null!");
            }
            try {
                this.syncMultiPartCryptoChangeSetDtosFromRemoteRepo(cryptoChangeSetDtoTooLargeException);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        this.getClient().execute((Request)new EndGetCryptoChangeSetDto(this.getRepositoryId().toString()));
        try {
            CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)this.getLocalRepoManager(), (UUID)this.getRepositoryId()).deleteAll();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        if (cryptoChangeSetDtoTooLargeException != null) {
            this.syncCryptoKeysFromRemoteRepo();
        }
    }

    protected void syncMultiPartCryptoChangeSetDtosFromRemoteRepo(CryptoChangeSetDtoTooLargeException cryptoChangeSetDtoTooLargeException) throws IOException {
        Uid multiPartId;
        int multiPartCount;
        AssertUtil.assertNotNull((Object)cryptoChangeSetDtoTooLargeException, (String)"cryptoChangeSetTooLargeException");
        String exMsg = cryptoChangeSetDtoTooLargeException.getMessage();
        try {
            multiPartCount = Integer.parseInt(exMsg);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("CryptoChangeSetDtoTooLargeException.message '" + exMsg + "' could not be parsed as integer!", x);
        }
        CryptoChangeSetDtoSplitFileManager cryptoChangeSetDtoSplitFileManager = CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)this.getLocalRepoManager(), (UUID)this.getRepositoryId());
        for (int multiPartIndex = 0; multiPartIndex < multiPartCount; ++multiPartIndex) {
            if (cryptoChangeSetDtoSplitFileManager.existsCryptoChangeSetDtoFile(multiPartIndex)) continue;
            byte[] fileData = (byte[])this.getClient().execute((Request)new GetCryptoChangeSetDtoFileData(this.getRepositoryId().toString(), multiPartIndex));
            cryptoChangeSetDtoSplitFileManager.writeCryptoChangeSetDtoFile(multiPartIndex, fileData);
        }
        if (cryptoChangeSetDtoSplitFileManager.getFinalFileCount() != multiPartCount) {
            throw new IllegalStateException("cryptoChangeSetDtoSplitFileManager.getFinalFileCount() != multiPartCount :: " + cryptoChangeSetDtoSplitFileManager.getFinalFileCount() + " != " + multiPartCount);
        }
        if (multiPartCount > 0) {
            CryptoChangeSetDto cryptoChangeSetDto = cryptoChangeSetDtoSplitFileManager.readCryptoChangeSetDto(0);
            multiPartId = cryptoChangeSetDto.getMultiPartId();
        } else {
            multiPartId = null;
        }
        for (int multiPartIndex = 0; multiPartIndex < multiPartCount; ++multiPartIndex) {
            if (cryptoChangeSetDtoSplitFileManager.isCryptoChangeSetDtoImported(multiPartIndex)) continue;
            CryptoChangeSetDto cryptoChangeSetDto = cryptoChangeSetDtoSplitFileManager.readCryptoChangeSetDto(multiPartIndex);
            if (multiPartId != null && !multiPartId.equals((Object)cryptoChangeSetDto.getMultiPartId())) {
                throw new IllegalStateException("cryptoChangeSetDto.getMultiPartId() != multiPartId :: " + cryptoChangeSetDto.getMultiPartId() + " != " + multiPartId);
            }
            if (cryptoChangeSetDto.getMultiPartCount() != multiPartCount) {
                throw new IllegalStateException("cryptoChangeSetDto.getMultiPartCount() != multiPartCount :: " + cryptoChangeSetDto.getMultiPartCount() + " != " + multiPartCount);
            }
            if (cryptoChangeSetDto.getMultiPartIndex() != multiPartIndex) {
                throw new IllegalStateException("cryptoChangeSetDto.getMultiPartIndex() != multiPartIndex :: " + cryptoChangeSetDto.getMultiPartIndex() + " != " + multiPartIndex);
            }
            this.syncCryptoKeysFromRemoteRepo_putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptoChangeSetDtoSplitFileManager.markCryptoChangeSetDtoImported(multiPartIndex);
        }
    }

    protected void syncCryptoKeysFromRemoteRepo_putCryptoChangeSetDto(CryptoChangeSetDto cryptoChangeSetDto) {
        if (logger.isInfoEnabled()) {
            logger.info("syncCryptoKeysFromRemoteRepo_putCryptoChangeSetDto: clientRepositoryId={} serverRepositoryId={}: cryptoRepoFileDtos.size={}, cryptoKeyDtos.size={}, cryptoLinkDtos.size={}, currentHistoCryptoRepoFileDtos.size={}, histoCryptoRepoFileDtos.size={}, histoFrameDtos.size={}, permissionDtos.size={}, permissionSetDtos.size={}, permissionSetInheritanceDtos.size={}, userIdentityDtos.size={}, userIdentityLinkDtos.size={}, userRepoKeyPublicKeyDtos.size={}, userRepoKeyPublicKeyReplacementRequestDtos.size={}, userRepoKeyPublicKeyReplacementRequestDeletionDtos.size={}, collisionDtos.size={}, cryptoConfigPropSetDtos.size={}", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), cryptoChangeSetDto.getCryptoRepoFileDtos().size(), cryptoChangeSetDto.getCryptoKeyDtos().size(), cryptoChangeSetDto.getCryptoLinkDtos().size(), cryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos().size(), cryptoChangeSetDto.getHistoCryptoRepoFileDtos().size(), cryptoChangeSetDto.getHistoFrameDtos().size(), cryptoChangeSetDto.getPermissionDtos().size(), cryptoChangeSetDto.getPermissionSetDtos().size(), cryptoChangeSetDto.getPermissionSetInheritanceDtos().size(), cryptoChangeSetDto.getUserIdentityDtos().size(), cryptoChangeSetDto.getUserIdentityLinkDtos().size(), cryptoChangeSetDto.getUserRepoKeyPublicKeyDtos().size(), cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDtos().size(), cryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDeletionDtos().size(), cryptoChangeSetDto.getCollisionDtos().size(), cryptoChangeSetDto.getCryptoConfigPropSetDtos().size()});
            DebugUtil.logMemoryStats((Logger)logger);
            logger.trace("syncCryptoKeysFromRemoteRepo: {}", (Object)cryptoChangeSetDto);
        }
        try (LocalRepoTransaction transaction = this.localRepoManager.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            cryptree.initLocalRepositoryType();
            cryptree.putCryptoChangeSetDto(cryptoChangeSetDto);
            logger.info("syncCryptoKeysFromRemoteRepo: after putCryptoChangeSetDto(...)");
            DebugUtil.logMemoryStats((Logger)logger);
            transaction.commit();
        }
    }

    private ChangeSetDto decryptChangeSetDto(ChangeSetDto changeSetDto) {
        AssertUtil.assertNotNull((Object)changeSetDto, (String)"changeSetDto");
        ChangeSetDto decryptedChangeSetDto = new ChangeSetDto();
        boolean debug = true;
        if (logger.isInfoEnabled()) {
            logger.info("decryptChangeSetDto: entered.");
            DebugUtil.logMemoryStats((Logger)logger);
        }
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            SignableVerifier signableVerifier = new SignableVerifier(cryptree.getUserRepoKeyPublicKeyLookup());
            decryptedChangeSetDto.setRepositoryDto(changeSetDto.getRepositoryDto());
            for (ModificationDto modificationDto : changeSetDto.getModificationDtos()) {
                this.verifySignatureAndPermission(cryptree, signableVerifier, modificationDto);
                ModificationDto decryptedModificationDto = this.decryptModificationDto(cryptree, modificationDto);
                if (decryptedModificationDto == null) continue;
                decryptedChangeSetDto.getModificationDtos().add(decryptedModificationDto);
            }
            int processedTreeNodeCount = 0;
            long lastLogTimestamp = System.currentTimeMillis();
            HashSet<Long> nonDecryptableRepoFileIds = new HashSet<Long>();
            RepoFileDtoTreeNode tree = RepoFileDtoTreeNode.createTree((Collection)changeSetDto.getRepoFileDtos());
            HashSet<RepoFileDtoTreeNode> deletedDuplicateCryptoRepoFileNodes = new HashSet<RepoFileDtoTreeNode>();
            if (tree != null) {
                for (RepoFileDtoTreeNode node : tree) {
                    if (deletedDuplicateCryptoRepoFileNodes.contains(node)) continue;
                    RepoFileDto repoFileDto = node.getRepoFileDto();
                    try {
                        this.verifySignatureAndTreeStructureAndPermission(cryptree, signableVerifier, node);
                    }
                    catch (CollisionException x) {
                        logger.warn("decryptChangeSetDto: " + (Object)((Object)x));
                        for (RepoFileDtoTreeNode nodeOrChild : node) {
                            deletedDuplicateCryptoRepoFileNodes.add(nodeOrChild);
                            changeSetDto.getRepoFileDtos().remove(nodeOrChild.getRepoFileDto());
                        }
                        continue;
                    }
                    if (nonDecryptableRepoFileIds.contains(repoFileDto.getParentId())) {
                        nonDecryptableRepoFileIds.add(repoFileDto.getId());
                        continue;
                    }
                    RepoFileDto decryptedRepoFileDto = this.decryptRepoFileDtoOnServer(cryptree, repoFileDto);
                    if (decryptedRepoFileDto == null) {
                        nonDecryptableRepoFileIds.add(repoFileDto.getId());
                    } else {
                        decryptedChangeSetDto.getRepoFileDtos().add(decryptedRepoFileDto);
                    }
                    ++processedTreeNodeCount;
                    if (System.currentTimeMillis() - lastLogTimestamp <= 10000L) continue;
                    logger.info("decryptChangeSetDto: processedTreeNodeCount={}", (Object)processedTreeNodeCount);
                    DebugUtil.logMemoryStats((Logger)logger);
                    lastLogTimestamp = System.currentTimeMillis();
                }
            }
            decryptedChangeSetDto.setParentConfigPropSetDto(cryptree.getParentConfigPropSetDtoIfNeeded());
            cryptree.createSyntheticDeleteModifications(decryptedChangeSetDto);
            if (logger.isInfoEnabled()) {
                logger.info("decryptChangeSetDto: before commit.");
                DebugUtil.logMemoryStats((Logger)logger);
            }
            transaction.commit();
        }
        if (logger.isInfoEnabled()) {
            logger.info("decryptChangeSetDto: after commit.");
            DebugUtil.logMemoryStats((Logger)logger);
        }
        logger.trace("decryptChangeSetDto: clientRepositoryId={} serverRepositoryId={}: {}", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), decryptedChangeSetDto});
        return decryptedChangeSetDto;
    }

    private void verifySignatureAndPermission(Cryptree cryptree, SignableVerifier signableVerifier, ModificationDto modificationDto) {
        if (!(modificationDto instanceof Signable)) {
            throw new IllegalArgumentException("modificationDto is not Signable: " + modificationDto);
        }
        if (modificationDto instanceof WriteProtected) {
            cryptree.assertSignatureOk((WriteProtected)modificationDto);
        } else {
            signableVerifier.verify((Signable)modificationDto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySignatureAndTreeStructureAndPermission(Cryptree cryptree, SignableVerifier signableVerifier, RepoFileDtoTreeNode node) throws SignatureException, WriteAccessDeniedException {
        RepoFileDto repoFileDto = node.getRepoFileDto();
        SsRepoFileDto ssRepoFileDto = (SsRepoFileDto)repoFileDto;
        boolean restoreVirtualRootName = false;
        try {
            SsDirectoryDto ssDirectoryDto;
            if (ssRepoFileDto instanceof SsDirectoryDto && this.isVirtualRootWithDifferentRealName(ssDirectoryDto = (SsDirectoryDto)ssRepoFileDto)) {
                restoreVirtualRootName = true;
                ssDirectoryDto.setName(ssDirectoryDto.getRealName());
            }
            try {
                signableVerifier.verify((Signable)ssRepoFileDto);
            }
            catch (SignatureException x) {
                throw new SignatureException(String.format("%s repoFileDto.name='%s' repoFileDto.parentName='%s'", x.getMessage(), ssRepoFileDto.getName(), ssRepoFileDto.getParentName()), (Throwable)x);
            }
            Signature signature = ssRepoFileDto.getSignature();
            Uid cryptoRepoFileId = repoFileDto.getName().isEmpty() ? cryptree.getRootCryptoRepoFileId() : new Uid(repoFileDto.getName());
            cryptree.assertIsNotDeletedDuplicateCryptoRepoFile(cryptoRepoFileId);
            cryptree.assertHasPermission(cryptoRepoFileId, signature.getSigningUserRepoKeyId(), PermissionType.write, signature.getSignatureCreated());
        }
        finally {
            if (restoreVirtualRootName) {
                ssRepoFileDto.setName("");
            }
        }
        if (repoFileDto.getParentId() == null) {
            this.assertRepoFileDtoIsCorrectRoot(cryptree, repoFileDto);
        } else {
            this.assertRepoFileParentNameMatchesParentRepoFileName(node);
        }
    }

    private void assertRepoFileDtoIsCorrectRoot(Cryptree cryptree, RepoFileDto repoFileDto) {
        AssertUtil.assertNotNull((Object)cryptree, (String)"cryptree");
        AssertUtil.assertNotNull((Object)repoFileDto, (String)"repoFileDto");
        SsDirectoryDto ssDirectoryDto = (SsDirectoryDto)repoFileDto;
        if (!repoFileDto.getName().isEmpty()) {
            throw new IllegalStateException(String.format("repoFileDto.name is not an empty String, but: '%s'", repoFileDto.getName()));
        }
        if (cryptree.getRemotePathPrefix().isEmpty()) {
            if (ssDirectoryDto.getRealName() != null) {
                throw new IllegalStateException(String.format("ssDirectoryDto.realName is not null, but: '%s'", ssDirectoryDto.getRealName()));
            }
        } else {
            Uid virtualRootCryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)cryptree.getCryptoRepoFileIdForRemotePathPrefixOrFail(), (String)"cryptree.getCryptoRepoFileIdForRemotePathPrefixOrFail()");
            if (!virtualRootCryptoRepoFileId.toString().equals(ssDirectoryDto.getRealName())) {
                throw new IllegalStateException(String.format("virtualRootCryptoRepoFileId != ssDirectoryDto.realName :: '%s' != '%s'", virtualRootCryptoRepoFileId, ssDirectoryDto.getRealName()));
            }
        }
    }

    private void assertRepoFileParentNameMatchesParentRepoFileName(RepoFileDtoTreeNode node) throws IllegalStateException {
        String parentRealName;
        AssertUtil.assertNotNull((Object)node, (String)"node");
        SsRepoFileDto ssRepoFileDto = (SsRepoFileDto)node.getRepoFileDto();
        String childParentName = (String)AssertUtil.assertNotNull((Object)ssRepoFileDto.getParentName(), (String)"ssRepoFileDto.parentName");
        RepoFileDtoTreeNode parent = (RepoFileDtoTreeNode)AssertUtil.assertNotNull((Object)node.getParent(), (String)"node.parent");
        RepoFileDto parentRepoFileDto = (RepoFileDto)AssertUtil.assertNotNull((Object)parent.getRepoFileDto(), (String)"node.parent.repoFileDto");
        SsDirectoryDto parentDirectoryDto = (SsDirectoryDto)parentRepoFileDto;
        String string = parentRealName = this.isVirtualRootWithDifferentRealName(parentDirectoryDto) ? parentDirectoryDto.getRealName() : parentDirectoryDto.getName();
        if (!childParentName.equals(parentRealName)) {
            throw new IllegalStateException(String.format("RepoFileDtoTreeNode tree structure does not match signed structure! ssRepoFileDto.parentName != parentRealName :: '%s' != '%s'", childParentName, parentRealName));
        }
    }

    private boolean isVirtualRootWithDifferentRealName(SsDirectoryDto ssDirectoryDto) {
        AssertUtil.assertNotNull((Object)ssDirectoryDto, (String)"ssDirectoryDto");
        return ssDirectoryDto.getRealName() != null && ssDirectoryDto.getName().isEmpty() && ssDirectoryDto.getParentId() == null;
    }

    private ModificationDto decryptModificationDto(Cryptree cryptree, ModificationDto modificationDto) {
        AssertUtil.assertNotNull((Object)modificationDto, (String)"modificationDto");
        if (modificationDto instanceof SsDeleteModificationDto) {
            return this.decryptDeleteModificationDto(cryptree, (SsDeleteModificationDto)modificationDto);
        }
        throw new UnsupportedOperationException("NYI");
    }

    private ModificationDto decryptDeleteModificationDto(Cryptree cryptree, SsDeleteModificationDto modificationDto) {
        AssertUtil.assertNotNull((Object)modificationDto, (String)"modificationDto");
        String localPath = cryptree.getLocalPath(modificationDto.getServerPath());
        modificationDto.setPath(localPath);
        return modificationDto;
    }

    private RepoFileDto decryptRepoFileDtoOnServer(Cryptree cryptree, RepoFileDto repoFileDto) {
        RepoFileDto decryptedRepoFileDto;
        Uid cryptoRepoFileId;
        AssertUtil.assertNotNull((Object)cryptree, (String)"cryptree");
        String name = ((RepoFileDto)AssertUtil.assertNotNull((Object)repoFileDto, (String)"repoFileDto")).getName();
        Uid uid = cryptoRepoFileId = repoFileDto.getParentId() == null && name.isEmpty() ? cryptree.getRootCryptoRepoFileId() : new Uid((String)AssertUtil.assertNotNull((Object)name, (String)"repoFileDto.name"));
        if (cryptoRepoFileId == null) {
            return null;
        }
        try {
            decryptedRepoFileDto = cryptree.getDecryptedRepoFileOnServerDtoOrFail(cryptoRepoFileId);
        }
        catch (AccessDeniedException | FileDeletedException x) {
            return null;
        }
        decryptedRepoFileDto.setId(repoFileDto.getId());
        decryptedRepoFileDto.setParentId(repoFileDto.getParentId());
        return decryptedRepoFileDto;
    }

    public void makeDirectory(String path, Date lastModified) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptree.createUnsealedHistoFrameIfNeeded();
            cryptoChangeSetDto = cryptree.createOrUpdateCryptoRepoFile(path);
            transaction.commit();
        }
        transaction = localRepoManager.beginWriteTransaction();
        var6_5 = null;
        try {
            cryptree = this.getCryptree(transaction);
            this.putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptree.updateLastCryptoKeySyncToRemoteRepo();
            CurrentHistoCryptoRepoFileDto chcrfDto = cryptree.createCurrentHistoCryptoRepoFileDto(path, true);
            String serverPath = cryptree.getServerPath(path);
            SsDirectoryDto directoryDto = this.createDirectoryDtoForMakeDirectory(cryptree, path, serverPath);
            RepoFileDtoWithCurrentHistoCryptoRepoFileDto rfdwchcrfd = new RepoFileDtoWithCurrentHistoCryptoRepoFileDto();
            rfdwchcrfd.setRepoFileDto((RepoFileDto)directoryDto);
            rfdwchcrfd.setCurrentHistoCryptoRepoFileDto(chcrfDto);
            logger.debug("makeDirectory: clientRepositoryId={} serverRepositoryId={} path='{}' serverPath='{}'", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), path, serverPath});
            this.getClient().execute((Request)new SsMakeDirectory(this.getRepositoryId().toString(), serverPath, rfdwchcrfd));
            transaction.commit();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var6_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected SsDirectoryDto createDirectoryDtoForMakeDirectory(Cryptree cryptree, String path, String serverPath) {
        UserRepoKey userRepoKey = cryptree.getUserRepoKeyOrFail(path, PermissionType.write);
        SsDirectoryDto directoryDto = new SsDirectoryDto();
        File f = OioFileFactory.createFile((String)serverPath);
        directoryDto.setName(f.getName());
        File pf = f.getParentFile();
        directoryDto.setParentName(pf == null ? null : pf.getName());
        directoryDto.setLastModified(SsDirectoryDto.DUMMY_LAST_MODIFIED);
        SignableSigner signableSigner = new SignableSigner(userRepoKey);
        signableSigner.sign((Signable)directoryDto);
        return directoryDto;
    }

    public void makeSymlink(String path, String target, Date lastModified) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptree.createUnsealedHistoFrameIfNeeded();
            cryptoChangeSetDto = cryptree.createOrUpdateCryptoRepoFile(path);
            transaction.commit();
        }
        transaction = localRepoManager.beginWriteTransaction();
        var7_6 = null;
        try {
            cryptree = this.getCryptree(transaction);
            this.putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptree.updateLastCryptoKeySyncToRemoteRepo();
            CurrentHistoCryptoRepoFileDto chcrfDto = cryptree.createCurrentHistoCryptoRepoFileDto(path, true);
            String serverPath = cryptree.getServerPath(path);
            SsSymlinkDto symlinkDto = this.createSymlinkDtoForMakeSymlink(cryptree, path, serverPath);
            RepoFileDtoWithCurrentHistoCryptoRepoFileDto rfdwchcrfd = new RepoFileDtoWithCurrentHistoCryptoRepoFileDto();
            rfdwchcrfd.setRepoFileDto((RepoFileDto)symlinkDto);
            rfdwchcrfd.setCurrentHistoCryptoRepoFileDto(chcrfDto);
            logger.debug("makeSymlink: clientRepositoryId={} serverRepositoryId={} path='{}' serverPath='{}'", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), path, serverPath});
            this.getClient().execute((Request)new SsMakeSymlink(this.getRepositoryId().toString(), serverPath, rfdwchcrfd));
            transaction.commit();
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var7_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private SsSymlinkDto createSymlinkDtoForMakeSymlink(Cryptree cryptree, String path, String serverPath) {
        UserRepoKey userRepoKey = cryptree.getUserRepoKeyOrFail(path, PermissionType.write);
        SsSymlinkDto symlinkDto = new SsSymlinkDto();
        File f = OioFileFactory.createFile((String)serverPath);
        symlinkDto.setName(f.getName());
        File pf = f.getParentFile();
        symlinkDto.setParentName(pf == null ? null : pf.getName());
        symlinkDto.setTarget("!");
        symlinkDto.setLastModified(SsSymlinkDto.DUMMY_LAST_MODIFIED);
        SignableSigner signableSigner = new SignableSigner(userRepoKey);
        signableSigner.sign((Signable)symlinkDto);
        return symlinkDto;
    }

    protected CryptreeFactory getCryptreeFactory() {
        if (this.cryptreeFactory == null) {
            this.cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
        }
        return this.cryptreeFactory;
    }

    protected Cryptree getCryptree(LocalRepoTransaction transaction) {
        return this.getCryptreeFactory().getCryptreeOrCreate(transaction, this.getRepositoryId(), this.getPathPrefix(), this.getUserRepoKeyRing());
    }

    protected UserRepoKeyRing getUserRepoKeyRing() {
        if (this.userRepoKeyRing == null) {
            UserRepoKeyRingLookup lookup = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup();
            UserRepoKeyRingLookupContext context = new UserRepoKeyRingLookupContext(this.getClientRepositoryIdOrFail(), this.getRepositoryId());
            this.userRepoKeyRing = lookup.getUserRepoKeyRing(context);
            if (this.userRepoKeyRing == null) {
                throw new IllegalStateException(String.format("UserRepoKeyRingLookup.getUserRepoKeyRing(context) returned null! lookup=%s context=%s", lookup, context));
            }
        }
        return this.userRepoKeyRing;
    }

    public void copy(String fromPath, String toPath) {
        throw new UnsupportedOperationException("not supported!");
    }

    public void move(String fromPath, String toPath) {
        throw new UnsupportedOperationException("not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SsDeleteModificationDto deleteModificationDto) {
        String path = deleteModificationDto.getPath();
        try {
            try (LocalRepoTransaction transaction = this.localRepoManager.beginReadTransaction();){
                Cryptree cryptree = this.getCryptree(transaction);
                cryptree.sign((WriteProtected)deleteModificationDto);
                deleteModificationDto.setPath(null);
                transaction.commit();
            }
            this.getClient().execute((Request)new SsDelete(this.getRepositoryId().toString(), deleteModificationDto));
        }
        finally {
            deleteModificationDto.setPath(path);
        }
    }

    public void delete(String path) {
        throw new UnsupportedOperationException("Replaced by delete(SsDeleteModificationDto)!");
    }

    public RepoFileDto getRepoFileDto(String path) {
        RepoFileDto result;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            NormalFileDto nf;
            Cryptree cryptree = this.getCryptree(transaction);
            RepoFileDto decryptedRepoFileDto = cryptree.getDecryptedRepoFileOnServerDto(path);
            LocalRepoStorage lrs = LocalRepoStorageFactoryRegistry.getInstance().getLocalRepoStorageFactoryOrFail().getLocalRepoStorageOrCreate(transaction, this.getRepositoryId(), this.getPathPrefix());
            if (decryptedRepoFileDto != null) {
                result = decryptedRepoFileDto;
            } else {
                result = lrs.getRepoFileDto(path);
                if (result instanceof NormalFileDto) {
                    nf = (SsNormalFileDto)result;
                    nf.getFileChunkDtos().clear();
                    nf.setLength(0L);
                    nf.setLengthWithPadding(0L);
                    nf.setLastModified(new Date());
                    nf.setSha1(HashUtil.sha1((String)Long.toString(System.currentTimeMillis(), 36)));
                }
            }
            if (result instanceof NormalFileDto) {
                nf = (NormalFileDto)result;
                nf.getTempFileChunkDtos().clear();
                nf.getTempFileChunkDtos().addAll(lrs.getTempFileChunkDtos(path));
            }
            transaction.commit();
        }
        return result;
    }

    public byte[] getFileData(String path, long offset, int length) {
        byte[] decryptedFileData;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            String unprefixedServerPath = this.unprefixPath(cryptree.getServerPath(path));
            byte[] encryptedFileData = this.getRestRepoTransport().getFileData(unprefixedServerPath, offset, length);
            UserRepoKeyPublicKeyLookup userRepoKeyPublicKeyLookup = cryptree.getUserRepoKeyPublicKeyLookup();
            Uid cryptoKeyId = this.readCryptoKeyId(encryptedFileData, userRepoKeyPublicKeyLookup);
            DataKey dataKey = cryptree.getDataKeyOrFail(cryptoKeyId);
            decryptedFileData = this.verifyAndDecrypt(encryptedFileData, dataKey.keyParameter, userRepoKeyPublicKeyLookup);
            transaction.commit();
        }
        return decryptedFileData;
    }

    public byte[] getHistoFileData(Uid histoCryptoRepoFileId, long offset) {
        byte[] decryptedFileData;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            byte[] encryptedFileData = (byte[])this.getClient().execute((Request)new GetHistoFileData(this.getRepositoryId().toString(), histoCryptoRepoFileId, offset));
            UserRepoKeyPublicKeyLookup userRepoKeyPublicKeyLookup = cryptree.getUserRepoKeyPublicKeyLookup();
            Uid cryptoKeyId = this.readCryptoKeyId(encryptedFileData, userRepoKeyPublicKeyLookup);
            DataKey dataKey = cryptree.getDataKeyOrFail(cryptoKeyId);
            decryptedFileData = this.verifyAndDecrypt(encryptedFileData, dataKey.keyParameter, userRepoKeyPublicKeyLookup);
            transaction.commit();
        }
        return decryptedFileData;
    }

    public void beginPutFile(String path) {
        throw new UnsupportedOperationException("Replaced by beginPutFile(String path, NormalFileDto fromNormalFileDto)!");
    }

    public void beginPutFile(String path, SsNormalFileDto fromNormalFileDto) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptoChangeSetDto = cryptree.createOrUpdateCryptoRepoFile(path);
            transaction.commit();
        }
        transaction = localRepoManager.beginWriteTransaction();
        var6_5 = null;
        try {
            cryptree = this.getCryptree(transaction);
            this.putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptree.updateLastCryptoKeySyncToRemoteRepo();
            String serverPath = cryptree.getServerPath(path);
            SsNormalFileDto serverNormalFileDto = this.createNormalFileDtoForPutFile(cryptree, path, serverPath, CryptreeRestRepoTransportImpl.assertNotNegative(fromNormalFileDto.getLengthWithPadding()));
            logger.debug("beginPutFile: clientRepositoryId={} serverRepositoryId={} path='{}' serverPath='{}'", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), path, serverPath});
            this.getClient().execute((Request)new SsBeginPutFile(this.getRepositoryId().toString(), serverPath, serverNormalFileDto));
            transaction.commit();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var6_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected SsNormalFileDto createNormalFileDtoForPutFile(Cryptree cryptree, String localPath, String serverPath, long lengthWithPadding) {
        UserRepoKey userRepoKey = cryptree.getUserRepoKeyOrFail(localPath, PermissionType.write);
        SsNormalFileDto normalFileDto = new SsNormalFileDto();
        File f = OioFileFactory.createFile((String)serverPath);
        normalFileDto.setName(f.getName());
        File pf = f.getParentFile();
        normalFileDto.setParentName(pf == null ? null : pf.getName());
        normalFileDto.setLength(lengthWithPadding);
        normalFileDto.setLastModified(SsRepoFileDto.DUMMY_LAST_MODIFIED);
        SignableSigner signableSigner = new SignableSigner(userRepoKey);
        signableSigner.sign((Signable)normalFileDto);
        return normalFileDto;
    }

    public void putFileData(final String path, long offset, byte[] fileData) {
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            DataKey dataKey = cryptree.getDataKeyOrFail(path);
            UserRepoKey userRepoKey = cryptree.getUserRepoKeyOrFail(path, PermissionType.write);
            byte[] encryptedFileData = this.encryptAndSign(fileData, dataKey, userRepoKey);
            String serverPath = cryptree.getServerPath(path);
            String unprefixedServerPath = this.unprefixPath(serverPath);
            logger.debug("putFileData: clientRepositoryId={} serverRepositoryId={} path='{}' serverPath='{}'", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), path, serverPath});
            try {
                this.getRestRepoTransport().putFileData(unprefixedServerPath, offset, encryptedFileData);
            }
            catch (CollisionException x) {
                transaction.addPostCloseListener((LocalRepoTransactionPostCloseListener)new LocalRepoTransactionPostCloseAdapter(){

                    public void postRollback(LocalRepoTransactionPostCloseEvent event) {
                        LocalRepoManager localRepoManager = event.getLocalRepoManager();
                        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
                            Cryptree cryptree = CryptreeRestRepoTransportImpl.this.getCryptree(transaction);
                            cryptree.getLocalRepoStorage().clearTempFileChunkDtos(path);
                            transaction.commit();
                        }
                        ((SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData()).scheduleReupload(path);
                    }

                    public void postCommit(LocalRepoTransactionPostCloseEvent event) {
                        throw new IllegalStateException("Commit is not allowed, anymore!");
                    }
                });
                throw x;
            }
            cryptree.getLocalRepoStorage().putTempFileChunkDto(path, offset);
            transaction.commit();
        }
    }

    public void endPutFile(String path, Date lastModified, long length, String sha1) {
        throw new UnsupportedOperationException("Replaced by endPutFile(String path, NormalFileDto fromNormalFileDto)!");
    }

    public void endPutFile(String path, NormalFileDto fromNormalFileDto) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptree.createUnsealedHistoFrameIfNeeded();
            cryptoChangeSetDto = cryptree.getCryptoChangeSetDtoOrFail(path);
            transaction.commit();
        }
        transaction = localRepoManager.beginWriteTransaction();
        var6_5 = null;
        try {
            cryptree = this.getCryptree(transaction);
            this.putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptree.updateLastCryptoKeySyncToRemoteRepo();
            String serverPath = cryptree.getServerPath(path);
            SsNormalFileDto serverNormalFileDto = this.createNormalFileDtoForPutFile(cryptree, path, serverPath, CryptreeRestRepoTransportImpl.assertNotNegative(((SsNormalFileDto)fromNormalFileDto).getLengthWithPadding()));
            RepoFileDtoWithCurrentHistoCryptoRepoFileDto rfdwchcrfd = new RepoFileDtoWithCurrentHistoCryptoRepoFileDto();
            CurrentHistoCryptoRepoFileDto chcrfDto = cryptree.createCurrentHistoCryptoRepoFileDto(path, true);
            rfdwchcrfd.setRepoFileDto((RepoFileDto)serverNormalFileDto);
            rfdwchcrfd.setCurrentHistoCryptoRepoFileDto(chcrfDto);
            logger.debug("endPutFile: clientRepositoryId={} serverRepositoryId={} path='{}' serverPath='{}'", new Object[]{this.getClientRepositoryId(), this.getRepositoryId(), path, serverPath});
            this.getClient().execute((Request)new SsEndPutFile(this.getRepositoryId().toString(), serverPath, rfdwchcrfd));
            cryptree.getLocalRepoStorage().clearTempFileChunkDtos(path);
            transaction.commit();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var6_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    protected static long assertNotNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value < 0");
        }
        return value;
    }

    protected byte[] encryptAndSign(byte[] plainText, DataKey dataKey, UserRepoKey signingUserRepoKey) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            try (SignerOutputStream signerOut = new SignerOutputStream((OutputStream)bout, signingUserRepoKey);){
                boolean version = true;
                signerOut.write(1);
                signerOut.write(dataKey.cryptoKeyId.toBytes());
                try (EncrypterOutputStream encrypterOut = new EncrypterOutputStream((OutputStream)signerOut, CryptoConfigUtil.getSymmetricCipherTransformation(), (CipherParameters)dataKey.keyParameter, (IvFactory)new RandomIvFactory());){
                    IOUtil.transferStreamData((InputStream)new ByteArrayInputStream(plainText), (OutputStream)encrypterOut);
                }
            }
            return bout.toByteArray();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * Exception decompiling
     */
    protected Uid readCryptoKeyId(byte[] cipherText, UserRepoKeyPublicKeyLookup userRepoKeyPublicKeyLookup) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] verifyAndDecrypt(byte[] cipherText, KeyParameter keyParameter, UserRepoKeyPublicKeyLookup userRepoKeyPublicKeyLookup) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(cipherText);
            try (VerifierInputStream verifierIn = new VerifierInputStream((InputStream)in, userRepoKeyPublicKeyLookup);){
                int version = verifierIn.read();
                if (version != 1) {
                    throw new IllegalStateException("version != 1");
                }
                IOUtil.readOrFail((InputStream)verifierIn, (byte[])new byte[16], (int)0, (int)16);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DecrypterInputStream decrypterIn = new DecrypterInputStream((InputStream)verifierIn, (CipherParameters)keyParameter);
                Object object = null;
                try {
                    IOUtil.transferStreamData((InputStream)decrypterIn, (OutputStream)bout);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (decrypterIn != null) {
                        if (object != null) {
                            try {
                                decrypterIn.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            decrypterIn.close();
                        }
                    }
                }
                byte[] plainText = bout.toByteArray();
                object = plainText;
                return object;
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x.getMessage() + " cipherText.length=" + cipherText.length, x);
        }
    }

    public void putCryptoChangeSetDto(CryptoChangeSetDto cryptoChangeSetDto) {
        AssertUtil.assertNotNull((Object)cryptoChangeSetDto, (String)"cryptoChangeSetDto");
        this.getClient().execute((Request)new PutCryptoChangeSetDto(this.getRepositoryId().toString(), cryptoChangeSetDto));
    }

    public void endSyncFromRepository() {
        this.getRestRepoTransport().endSyncFromRepository();
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            Cryptree cryptree = this.getCryptree(transaction);
            if (!cryptree.isEmpty()) {
                cryptree.getDataKeyOrFail("");
            }
            transaction.commit();
        }
    }

    public void endSyncToRepository(long fromLocalRevision) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Cryptree cryptree;
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            cryptree = this.getCryptree(transaction);
            cryptree.sealUnsealedHistoryFrame();
            cryptree.prepareGetCryptoChangeSetDtoWithCryptoRepoFiles(null);
            cryptoChangeSetDto = cryptree.getCryptoChangeSetDtoWithCryptoRepoFiles(null);
            cryptree.removeOrphanedInvitationUserRepoKeyPublicKeys();
            transaction.commit();
        }
        transaction = localRepoManager.beginWriteTransaction();
        var6_4 = null;
        try {
            cryptree = this.getCryptree(transaction);
            this.putCryptoChangeSetDto(cryptoChangeSetDto);
            cryptree.updateLastCryptoKeySyncToRemoteRepo();
            transaction.commit();
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var6_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        this.getRestRepoTransport().endSyncToRepository(fromLocalRevision);
    }

    public Long getLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced() {
        return (Long)this.getClient().execute((Request)new GetLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced(this.getRepositoryId().toString()));
    }

    protected URL determineRemoteRootWithoutPathPrefix() {
        return this.getRestRepoTransport().determineRemoteRootWithoutPathPrefix();
    }

    protected CloudStoreRestClient getClient() {
        return this.getRestRepoTransport().getClient();
    }

    public LocalRepoManager getLocalRepoManager() {
        if (this.localRepoManager == null) {
            logger.debug("getLocalRepoManager: Creating a new LocalRepoManager.");
            File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRoot(this.getClientRepositoryIdOrFail());
            this.localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
        }
        return this.localRepoManager;
    }

    protected RestRepoTransport getRestRepoTransport() {
        if (this.restRepoTransport == null) {
            RestRepoTransportFactory restRepoTransportFactory = this.getRepoTransportFactory().restRepoTransportFactory;
            this.restRepoTransport = (RestRepoTransport)restRepoTransportFactory.createRepoTransport((URL)AssertUtil.assertNotNull((Object)this.getRemoteRoot(), (String)"getRemoteRoot()"), (UUID)AssertUtil.assertNotNull((Object)this.getClientRepositoryId(), (String)"getClientRepositoryId()"));
        }
        return this.restRepoTransport;
    }

    public final CryptreeRestRepoTransportFactoryImpl getRepoTransportFactory() {
        return (CryptreeRestRepoTransportFactoryImpl)super.getRepoTransportFactory();
    }

    public void close() {
        if (this.localRepoManager != null) {
            logger.debug("close: Closing localRepoManager.");
            this.localRepoManager.close();
        } else {
            logger.debug("close: There is no localRepoManager.");
        }
        if (this.restRepoTransport != null) {
            logger.debug("close: Closing restRepoTransport.");
            this.restRepoTransport.close();
        } else {
            logger.debug("close: There is no restRepoTransport.");
        }
        super.close();
    }

    public VersionInfoDto getVersionInfoDto() {
        return this.getRestRepoTransport().getVersionInfoDto();
    }

    public void putParentConfigPropSetDto(ConfigPropSetDto parentConfigPropSetDto) {
        throw new UnsupportedOperationException("It is not supported to connect a server-repository to a client-repository's sub-directory! Only the other way around is supported. This method should thus never be invoked.");
    }
}

