/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.ls.server.cproc;

import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.locker.sync.LockerSyncDaemonImpl;
import org.subshare.core.locker.transport.LockerTransportFactoryRegistry;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStoreImpl;
import org.subshare.core.pgp.sync.PgpSyncDaemonImpl;
import org.subshare.core.pgp.transport.PgpTransportFactoryRegistryImpl;
import org.subshare.core.repo.metaonly.MetaOnlyRepoSyncDaemonImpl;
import org.subshare.core.repo.sync.RepoSyncTimerImpl;
import org.subshare.ls.server.cproc.ssl.AcceptAllDynamicX509TrustManagerCallback;
import org.subshare.rest.client.locker.transport.RestLockerTransportFactory;
import org.subshare.rest.client.pgp.transport.RestPgpTransportFactory;
import org.subshare.rest.client.transport.CryptreeRestRepoTransportFactoryImpl;

public class LocalServerInit {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerInit.class);
    private static boolean initPrepareDone;
    private static boolean initFinishDone;

    private LocalServerInit() {
    }

    public static synchronized void initPrepare() {
        if (!initPrepareDone) {
            ((RestPgpTransportFactory)PgpTransportFactoryRegistryImpl.getInstance().getPgpTransportFactoryOrFail(RestPgpTransportFactory.class)).setDynamicX509TrustManagerCallbackClass(AcceptAllDynamicX509TrustManagerCallback.class);
            ((RestLockerTransportFactory)LockerTransportFactoryRegistry.getInstance().getLockerTransportFactoryOrFail(RestLockerTransportFactory.class)).setDynamicX509TrustManagerCallbackClass(AcceptAllDynamicX509TrustManagerCallback.class);
            CryptreeRestRepoTransportFactoryImpl cryptreeRestRepoTransportFactoryImpl = (CryptreeRestRepoTransportFactoryImpl)RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(CryptreeRestRepoTransportFactoryImpl.class);
            cryptreeRestRepoTransportFactoryImpl.setDynamicX509TrustManagerCallbackClass(AcceptAllDynamicX509TrustManagerCallback.class);
            PgpAuthenticationCallback pgpAuthenticationCallback = PgpPrivateKeyPassphraseStoreImpl.getInstance().getPgpAuthenticationCallback();
            PgpRegistry.getInstance().setPgpAuthenticationCallback(pgpAuthenticationCallback);
            initPrepareDone = true;
        }
    }

    public static synchronized void initFinish() {
        if (!initFinishDone) {
            Thread localServerInitFinishThread = new Thread(){

                @Override
                public void run() {
                    PgpSyncDaemonImpl.getInstance().sync();
                    LockerSyncDaemonImpl.getInstance().sync();
                    MetaOnlyRepoSyncDaemonImpl.getInstance().sync();
                    RepoSyncTimerImpl.getInstance();
                }
            };
            localServerInitFinishThread.start();
            initFinishDone = true;
        }
    }
}

