/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui;

import java.util.Arrays;
import java.util.Collection;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import org.subshare.gui.maintree.LocalRepoListMainTreeItem;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.RootMainTreeItem;
import org.subshare.gui.maintree.ServerListMainTreeItem;
import org.subshare.gui.maintree.UserListMainTreeItem;
import org.subshare.gui.scene.MainDetailContent;

public class MainPaneController {
    @FXML
    private SplitPane splitPane;
    @FXML
    private BorderPane mainTreePane;
    @FXML
    private TreeView<String> mainTreeView;
    @FXML
    private BorderPane mainDetail;

    public void initialize() {
        RootMainTreeItem root = new RootMainTreeItem(this.mainTreeView);
        root.getChildren().addAll((Collection)FXCollections.observableArrayList(Arrays.asList(new MainTreeItem[]{new LocalRepoListMainTreeItem(), new ServerListMainTreeItem(), new UserListMainTreeItem()})));
        this.mainTreeView.setShowRoot(false);
        this.mainTreeView.setRoot((TreeItem)root);
        this.mainTreeView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.onSelectionChange());
        this.mainTreeView.getSelectionModel().select(0);
        Platform.runLater(() -> Platform.runLater(() -> Platform.runLater(() -> this.splitPane.setDividerPosition(0, 0.3))));
    }

    private void onSelectionChange() {
        Parent newMainDetailContent;
        Node oldMainDetailContent = this.mainDetail.getCenter();
        MainTreeItem selectedItem = (MainTreeItem)((Object)this.mainTreeView.getSelectionModel().getSelectedItem());
        Parent parent = newMainDetailContent = selectedItem == null ? null : selectedItem.getMainDetailContent();
        if (oldMainDetailContent instanceof MainDetailContent) {
            ((MainDetailContent)oldMainDetailContent).onHidden();
        }
        this.mainDetail.setCenter((Node)newMainDetailContent);
        if (newMainDetailContent instanceof MainDetailContent) {
            ((MainDetailContent)newMainDetailContent).onShown();
        }
    }
}

