/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.certify;

import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.subshare.core.pgp.CertifyPgpKeyParam;
import org.subshare.core.pgp.Pgp;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;
import org.subshare.gui.pgp.certify.CertifyPgpKeyWizardPage;
import org.subshare.gui.pgp.certify.Messages;
import org.subshare.gui.wizard.Wizard;

public class CertifyPgpKeyWizard
extends Wizard {
    private final CertifyPgpKeyData certifyPgpKeyData;
    private CertifyPgpKeyParam certifyPgpKeyParam;

    public CertifyPgpKeyWizard(CertifyPgpKeyData certifyPgpKeyData) {
        this.certifyPgpKeyData = (CertifyPgpKeyData)AssertUtil.assertNotNull((Object)certifyPgpKeyData, (String)"certifyPgpKeyData");
        AssertUtil.assertNotNull((Object)certifyPgpKeyData.getPgpKey(), (String)"certifyPgpKeyData.pgpKey");
        this.setFirstPage(new CertifyPgpKeyWizardPage(certifyPgpKeyData));
    }

    @Override
    public String getTitle() {
        return Messages.getString("CertifyPgpKeyWizard.title");
    }

    @Override
    protected void finishing() {
        super.finishing();
        this.certifyPgpKeyParam = new CertifyPgpKeyParam();
        this.certifyPgpKeyParam.setPgpKey(this.certifyPgpKeyData.getPgpKey());
        this.certifyPgpKeyParam.setCertificationLevel(this.certifyPgpKeyData.getCertificationLevel());
        this.certifyPgpKeyParam.setSignPgpKey(this.certifyPgpKeyData.getSignPgpKey());
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        Pgp pgp = PgpLs.getPgpOrFail();
        pgp.certify(this.certifyPgpKeyParam);
        pgp.updateTrustDb();
    }
}

