/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.subshare.core.CryptreeFactory;

public class CryptreeFactoryRegistry {
    private List<CryptreeFactory> cryptreeFactories;

    protected CryptreeFactoryRegistry() {
    }

    public static CryptreeFactoryRegistry getInstance() {
        return Holder.instance;
    }

    public synchronized List<CryptreeFactory> getCryptreeFactories() {
        List<CryptreeFactory> cryptreeFactories = this.cryptreeFactories;
        if (cryptreeFactories == null) {
            cryptreeFactories = CryptreeFactoryRegistry.loadCryptreeFactoriesViaServiceLoader();
            CryptreeFactoryRegistry.sortCryptreeFactories(cryptreeFactories);
            this.cryptreeFactories = cryptreeFactories = Collections.unmodifiableList(cryptreeFactories);
        }
        return cryptreeFactories;
    }

    private static List<CryptreeFactory> loadCryptreeFactoriesViaServiceLoader() {
        ArrayList<CryptreeFactory> cryptreeFactories = new ArrayList<CryptreeFactory>();
        ServiceLoader<CryptreeFactory> sl = ServiceLoader.load(CryptreeFactory.class);
        Iterator<CryptreeFactory> it = sl.iterator();
        while (it.hasNext()) {
            cryptreeFactories.add(it.next());
        }
        cryptreeFactories.trimToSize();
        return cryptreeFactories;
    }

    protected static int _compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void sortCryptreeFactories(List<CryptreeFactory> cryptreeFactories) {
        Collections.sort(cryptreeFactories, new Comparator<CryptreeFactory>(){

            @Override
            public int compare(CryptreeFactory o1, CryptreeFactory o2) {
                int result = -1 * CryptreeFactoryRegistry._compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public CryptreeFactory getCryptreeFactoryOrFail() {
        List<CryptreeFactory> cryptreeFactories = this.getCryptreeFactories();
        if (cryptreeFactories.isEmpty()) {
            throw new IllegalStateException("There is no CryptreeFactory registered!");
        }
        return cryptreeFactories.get(0);
    }

    private static class Holder {
        static CryptreeFactoryRegistry instance = new CryptreeFactoryRegistry();

        private Holder() {
        }
    }
}

